% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_selection.R
\name{calculate_gene_peakedness}
\alias{calculate_gene_peakedness}
\title{calculate_gene_peakedness}
\usage{
calculate_gene_peakedness(
  sce,
  window_pct = 10,
  pseudotime_slot = "slingPseudotime_1",
  knots = 10,
  BPPARAM = BiocParallel::SerialParam()
)
}
\arguments{
\item{sce}{\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment::SingleCellExperiment} to
do the calculations on.}

\item{window_pct}{Decimal between 0-100. The size of
the window to consider, as a percentage of the maximum pseudotime value.}

\item{pseudotime_slot}{String. The name of the metadata column in the SCE
object containing pseudotime}

\item{knots}{Integer. The number of knots to use when fitting the GAM}

\item{BPPARAM}{The \link[BiocParallel:BiocParallelParam-class]{BiocParallel::BiocParallelParam} for
parallelisation. Defaults to \link[BiocParallel:SerialParam-class]{BiocParallel::SerialParam}.}
}
\value{
Dataframe, where each row is a gene, and the following columns:
mean_expression_in_window (decimal), mean_expression_out_window (decimal),
ratio (decimal)
}
\description{
Calculate the peakedness of a gene. The power is the ratio of the mean of
reads 5\% either side of the smoothed peak of the gene's expression over
pseudotime against the mean of the reads outside of this.

This function can take some time to complete, please be patient.
}
\examples{
ncells <- 70
ngenes <- 100
# Each gene should have mean around its gene number
counts <- c()
for (i in seq_len(ngenes)) {
    counts <- c(counts, dnorm(seq_len(ncells), mean = (ncells / i), sd = 1))
}

counts_matrix <- matrix(
    counts,
    ncol = ncells,
    nrow = ngenes
)
sce <- SingleCellExperiment::SingleCellExperiment(assays = list(
    counts = counts_matrix * 3,
    normcounts = counts_matrix,
    logcounts = log(counts_matrix)
))
colnames(sce) <- paste0("cell", seq_len(ncells))
rownames(sce) <- paste0("gene", seq_len(ngenes))
sce$cell_type <- c(
    rep("celltype_1", ncells / 2),
    rep("celltype_2", ncells / 2)
)

sce$pseudotime <- seq_len(ncells) - 1
genelist <- rownames(sce)

# calculate_gene_peakedness
gene_peakedness <- calculate_gene_peakedness(
    sce,
    pseudotime_slot = "pseudotime"
)

head(gene_peakedness)

# plot_gene_peakedness
plot_gene_peakedness(sce, gene_peakedness, "gene20",
    pseudotime_slot = "pseudotime"
)

# smooth_gene
smoothed_gene20 <- smooth_gene(
    sce, "gene20",
    pseudotime_slot = "pseudotime"
)
head(smoothed_gene20)

# Select best spread of genes
genes_to_use <- gene_peakedness_spread_selection(sce, gene_peakedness,
    genes_per_bin = 2, n_gene_bins = 1, pseudotime_slot = "pseudotime"
)

print(genes_to_use)
plot(
    x = gene_peakedness[
        gene_peakedness$gene \%in\% genes_to_use, "peak_pseudotime"
    ],
    y = gene_peakedness[gene_peakedness$gene \%in\% genes_to_use, "ratio"]
)

}
\concept{gene-selection}
