% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier_analysis_functions.R
\name{make_outlier_table}
\alias{make_outlier_table}
\title{Separate out the "i"th gene, take the bounds, and then create a column
that says whether or not this gene is high, low, or none in a sample with
regards to the other samples in the dataset. Repeat this for every gene to
create a reference table.}
\usage{
make_outlier_table(intable, analyze_negative_outliers = FALSE)
}
\arguments{
\item{intable}{table with all of the inputted information, samples along the
x-axis, features along the y-axis}

\item{analyze_negative_outliers}{DEFAULT: FALSE; Toggle the analysis of
outliers in the negative direction. Will lead to the output of
the outlier table containing "-1" values, in addition to negative outputs
for boundaries and aggregate tables (if applicable)}
}
\value{
a list with varied sections depending on parameters:
    $outliertab - table converted to outlier form with 0s, 1s, and -1s,
    $upperboundtab - list of upper boundaries for outliers
    $lowerboundtab - list of lower boundaries of outliers
    $sampmedtab - list of median value per feature
}
\description{
Separate out the "i"th gene, take the bounds, and then create a column
that says whether or not this gene is high, low, or none in a sample with
regards to the other samples in the dataset. Repeat this for every gene to
create a reference table.
}
\examples{
data("sample_phosphodata")
reftable_function_out <- make_outlier_table(sample_phosphodata[1:1000,],
    analyze_negative_outliers = FALSE)
outliertab <- reftable_function_out$outliertab
upperboundtab <- reftable_function_out$upperboundtab
lowerboundtab <- reftable_function_out$lowerboundtab
sampmedtab <- reftable_function_out$sampmedtab
}
\keyword{blacksheepr}
\keyword{deva}
\keyword{outliers}
