% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier_analysis_functions.R
\name{deva}
\alias{deva}
\title{Run the entire blacksheep Function from Start to finish}
\usage{
deva(se, analyze_negative_outliers = FALSE,
    aggregate_features = FALSE, feature_delineator = "\\\\.",
    fraction_samples_cutoff = 0.3, fdrcutoffvalue = 0.1)
}
\arguments{
\item{se}{The SummarizedExperiment object containing the countdata and the
associated annotation data with comparisons in the colData object.}

\item{analyze_negative_outliers}{DEFAULT: FALSE; Toggle the analysis of
outliers in the negative direction as well. Will lead to the output of
the outlier table containing "-1" values, in addition to negative outputs
for boundaries and aggregate tables (if applicable)}

\item{aggregate_features}{DEFAULT: FALSE; Toggle the Aggregate feature, which
will aggregate features in your table based on the given delineator.
Aggregation will output an aggregate table that counts the number of
outliers per feature, and also a fraction table that show the number of
outliers / number of candidates (which excludes missing values)}

\item{feature_delineator}{DEFAULT: <"\\."> What character delineates the
separation between primary and secondary features. NOTE: to use proper
R syntax with escape characters if necessary
Ex) Protein1.Phosphosite1 uses "\\." to aggregate on Protein1}

\item{fraction_samples_cutoff}{DEFAULT: 0.3; Input a fractional cut off for
the of samples that need to have an outlier for feature to be
considered. ex) 10 samples in ingroup - 3 need to have an outlier for
feature to be considered significant}

\item{fdrcutoffvalue}{DEFAULT: 0.1; The FDR value for significance}
}
\value{
outputs the full output of deva, including the analysis tables, the
    heatmaps for the analyses, the fraction table showing the fraction of
    outliers per sample, and the median and boundary values that together
    comprise the outlier boundary
}
\description{
Run the entire blacksheep Function from Start to finish
}
\examples{

suppressPackageStartupMessages(library(SummarizedExperiment))
data("sample_phosphodata")
data("sample_annotationdata")

se <- SummarizedExperiment(
    assays = list(counts = as.matrix(sample_phosphodata[1:1000,])),
    colData = DataFrame(sample_annotationdata))

deva(se = se,
    analyze_negative_outliers = FALSE, aggregate_features = FALSE,
    feature_delineator = "-", fraction_samples_cutoff = 0.3,
    fdrcutoffvalue = 0.1)


}
\keyword{blacksheepr}
\keyword{deva}
\keyword{outliers}
