% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier_plotting_functions.R
\name{annotationlist_builder}
\alias{annotationlist_builder}
\title{Create the annotation object for plotting in a heatmap}
\usage{
annotationlist_builder(metatable, customcolorlist = NULL)
}
\arguments{
\item{metatable}{the metatable containing information for the columns}

\item{customcolorlist}{DEFAULT: NULL, enter colorlist to manually set colors}
}
\value{
return the annotation object
}
\description{
Create the annotation object for plotting in a heatmap
}
\examples{
metatable <- data.frame(row.names = c("samp1", "samp2", "samp3", "samp4"),
    A = c(rep("high", 2), rep("low", 2)), B = seq(1,7,2))
customcolorlist <- list(A = c("high" = "red", "low" = "blue"),
    B = circlize::colorRamp2(seq(-5, 5, length = 3),
    RColorBrewer::brewer.pal(3, "Reds")))
annotationlist_builder(metatable, customcolorlist)
}
\keyword{blacksheepr}
\keyword{deva}
\keyword{outliers}
