% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeHeatmap.R
\name{makeHeatmap}
\alias{makeHeatmap}
\title{Create a summary heatmap}
\usage{
makeHeatmap(
  bettrList = NULL,
  plotdata,
  scoredata,
  idCol,
  metricCol = "Metric",
  valueCol = "ScaledValue",
  weightCol = "Weight",
  scoreCol = "Score",
  metricGroupCol = "metricGroup",
  metricInfo,
  metricColors,
  idInfo,
  idColors,
  metricCollapseGroup = FALSE,
  metricGrouping = "---",
  labelSize = 10,
  showRowNames = TRUE,
  plotType = "Heatmap",
  rownamewidth_cm = 6,
  colnameheight_cm = 6
)
}
\arguments{
\item{bettrList}{A \code{list}, the output object from \code{prepData}.
If \code{bettrList} is provided, arguments \code{plotdata},
\code{scoredata}, \code{idCol}, \code{metricCol}, \code{valueCol},
\code{weightCol}, \code{scoreCol}, \code{metricGroupCol},
\code{metricInfo}, \code{metricColors}, \code{idInfo}, \code{idColors},
\code{metricCollapseGroup}, \code{metricGrouping} and \code{methods}
will be ignored and the corresponding values will be extracted from
\code{bettrList}. This is the recommended way of calling the plotting
functions, as it ensures compatibility of all components.}

\item{plotdata}{A \code{data.frame} with columns representing methods,
metrics, scores, and weights. Typically obtained as
\code{prepData$plotdata}, where \code{prepData} is the output from
\code{bettrGetReady}.}

\item{scoredata}{A \code{data.frame} with columns representing methods,
aggregated scores, and any other method annotations. Typically
obtained as \code{prepData$scoredata}, where \code{prepData} is the
output from \code{bettrGetReady}.}

\item{idCol}{Character scalar indicating which column of \code{plotdata} and
\code{scoredata} contains the method IDs.}

\item{metricCol}{Character scalar indicating which column of \code{plotdata}
contains the metric IDs. Typically, \code{"Metric"}.}

\item{valueCol}{Character scalar indicating which column of \code{plotdata}
contains the metric values. Typically, \code{"ScaledValue"}.}

\item{weightCol}{Character scalar indicating which column of \code{plotdata}
contains the weight values. Typically, \code{"Weight"}.}

\item{scoreCol}{Character scalar indicating which column of \code{scoredata}
contains the aggregated score values. Typically, \code{"Score"}.}

\item{metricGroupCol}{Character scalar indicating which column of
\code{plotdata} contains the information about the metric group.
Typically, \code{"metricGroup"}.}

\item{metricInfo}{\code{data.frame} with annotations for metrics. Typically
obtained as \code{prepData$metricInfo}, where \code{prepData} is the
output from \code{bettrGetReady}.}

\item{metricColors}{Named list with colors used for the metrics and
any other metric annotations. Typically obtained as
\code{prepData$metricColors}, where \code{prepData} is the output from
\code{bettrGetReady}.}

\item{idInfo}{\code{data.frame} with annotations for entities. Typically
obtained as \code{prepData$idInfo}, where \code{prepData} is the
output from \code{bettrGetReady}.}

\item{idColors}{Named list with colors used for methods and any other
method annotations. Typically obtained as \code{prepData$idColors},
where \code{prepData} is the output from \code{bettrGetReady}.}

\item{metricCollapseGroup}{Logical scalar indicating whether metrics
should be collapsed by the group variable provided by
\code{metricGrouping}. Typically obtained as
\code{prepData$metricCollapseGroup}, where \code{prepData} is the
output from \code{bettrGetReady}.}

\item{metricGrouping}{Character scalar indicating the column of
\code{metricInfo} that was used to group metrics. Typically obtained as
\code{prepData$metricGrouping}, where \code{prepData} is the output
from \code{bettrGetReady}.}

\item{labelSize}{Numeric scalar providing the size of the labels in the plot.}

\item{showRowNames}{Logical scalar indicating whether to show row (method)
names in the heatmap.}

\item{plotType}{Either \code{"Heatmap"} or \code{"Dot plot"} indicating the
type of plot to construct.}

\item{rownamewidth_cm, colnameheight_cm}{Numeric scalars defining the width
of row names and height of column names, in cm.}
}
\value{
A \code{\link[ComplexHeatmap]{HeatmapList}} object.
}
\description{
Create a summary heatmap. The input arguments for this functions are
typically generated using \code{\link{bettrGetReady}}, which ensures that
all required columns are available.
}
\examples{
## Generate example data
df <- data.frame(Method = c("M1", "M2", "M3"),
                 metric1 = c(1, 2, 3),
                 metric2 = c(3, 1, 2))
metricInfo <- data.frame(Metric = c("metric1", "metric2", "metric3"),
                         Group = c("G1", "G2", "G2"))
idInfo <- data.frame(Method = c("M1", "M2", "M3"),
                     Type = c("T1", "T1", "T2"))
prepData <- bettrGetReady(df = df, idCol = "Method",
                          metricInfo = metricInfo, idInfo = idInfo)
makeHeatmap(bettrList = prepData, plotType = "Heatmap")
makeHeatmap(bettrList = prepData, plotType = "Dot plot")

}
\author{
Charlotte Soneson
}
