% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brew.R
\name{brewOne}
\alias{brewOne}
\title{Run BEER for one sample}
\usage{
brewOne(
  object,
  sample,
  prior.params,
  n.chains = 1,
  n.adapt = 1000,
  n.iter = 10000,
  thin = 1,
  na.rm = TRUE,
  ...,
  seed = as.numeric(format(Sys.Date(), "\%Y\%m\%d"))
)
}
\arguments{
\item{object}{PhIPData object}

\item{sample}{sample name}

\item{prior.params}{vector of prior parameters}

\item{n.chains}{number of chains to run}

\item{n.adapt}{number of iterations to use as burn-in.}

\item{n.iter}{number of iterations for the MCMC chain to run (after n.adapt)}

\item{thin}{thinning parameter}

\item{na.rm}{what to do with NA values (for JAGS)}

\item{...}{extra parameters for JAGS}

\item{seed}{number/string for reproducibility purposes.}
}
\value{
nothing, saves the the results to an RDS in either a temp directory
or the specified directory.
}
\description{
This function is not really for external use. It's exported for
parallelization purposes. For more detailed descriptions see
\code{\link{brew}}.
}
\examples{
sim_data <- readRDS(system.file("extdata", "sim_data.rds", package = "beer"))

beads_prior <- getAB(subsetBeads(sim_data), "edgeR")
brewOne(sim_data, "9", list(
    a_0 = beads_prior[["a_0"]],
    b_0 = beads_prior[["b_0"]],
    a_pi = 2, b_pi = 300,
    a_phi = 1.25, b_phi = 0.1,
    a_c = 80, b_c = 20,
    fc = 1
))
}
