% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_banocc.R
\name{run_banocc}
\alias{run_banocc}
\title{Runs BAnOCC to fit the model and generate appropriate convergence metrics
  and inference.}
\usage{
run_banocc(compiled_banocc_model, C, n = rep(0, ncol(C)), L = 10 *
  diag(ncol(C)), a = 0.5, b = 0.01, cores = getOption("mc.cores", 1L),
  chains = 4, iter = 50, warmup = floor(iter/2), thin = 1,
  init = NULL, control = NULL, verbose = FALSE, num_level = 0)
}
\arguments{
\item{compiled_banocc_model}{The compiled stan model (as with
\code{stan_model(model_code = banocc_model)}).}

\item{C}{The dataset as a data frame or matrix. This should be N by P
with N samples as the rows and P features as the columns.}

\item{n}{The prior mean for m; vectors of length less than P (the number
of features/columns of \code{C}) will be recycled.}

\item{L}{The prior variance-covariance for m (must be
positive-definite with dimension PxP where P=number of features/columns
in \code{C}), or a vector of length p of variances for m. If a vector of
length less than P is given, it will be recycled.}

\item{a}{The shape parameter of a gamma distribution (the prior on the
shrinkage parameter lambda)}

\item{b}{The rate parameter of a gamma distribution (the prior on the
shrinkage parameter lambda)}

\item{cores}{Number of cores to use when executing the chains in parallel,
    which defaults to 1 but we recommend setting the \code{mc.cores} option 
    to be as many processors as the hardware and RAM allow (up to the 
    number of chains).}

\item{chains}{A positive integer specifying the number of Markov chains. 
    The default is 4.}

\item{iter}{A positive integer specifying the number of iterations for each 
    chain (including warmup). The default is 2000.}

\item{warmup}{A positive integer specifying the number of warmup (aka burnin)
    iterations per chain. If step-size adaptation is on (which it is by default), 
    this also controls the number of iterations for which adaptation is run (and
    hence these warmup samples should not be used for inference). The number of 
    warmup iterations should not be larger than \code{iter} and the default is 
    \code{iter/2}.}

\item{thin}{A positive integer specifying the period for saving samples. 
    The default is 1, which is usually the recommended value.}

\item{init}{The initial values as a list (see
\code{\link[rstan]{sampling}} in the \code{rstan} package). Default
value is NULL, which means that initial values are sampled from the
priors for parameters m and lambda while O is set to the identity matrix.}

\item{control}{A named \code{list} of parameters to control the sampler's
    behavior. See the details in the documentation for the \code{control} argument
    in \code{\link{stan}}.}

\item{verbose}{Print informative statements as the function executes?}

\item{num_level}{The number of indentations to add to the output when
\code{verbose = TRUE}.}
}
\value{
Returns a named list with the following elements:
\describe{
  \item{\emph{Data}}{The data formatted as a named list that includes the
    input data (\code{C}) and the prior parameters (\code{n}, \code{L},
    \code{a}, \code{b})}

  \item{\emph{Fit}}{The \code{stanfit} object returned by the call to
    \code{\link[rstan]{sampling}}}
}
}
\description{
Runs BAnOCC to fit the model and generate appropriate convergence metrics
  and inference.
}
\examples{
  data(compositions_null)
  \dontrun{
    compiled_banocc_model <- rstan::stan_model(model_code=banocc_model)
    b_stanfit <- run_banocc(C=compositions_null,
                            compiled_banocc_model=compiled_banocc_model)
  }

}
\seealso{
\code{vignette("banocc-vignette")} for more examples.
}

