% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/methods-bandle.R
\docType{class}
\name{bandleChains-class}
\alias{bandleChains-class}
\alias{.bandleChains}
\alias{bandleSummary-class}
\alias{.bandleSummary}
\alias{bandleSummaries-class}
\alias{.bandleSummaries}
\alias{bandleParams-class}
\alias{.bandleParams}
\alias{nicheParam-class}
\alias{.nicheParam}
\alias{nicheParams-class}
\alias{.nicheParams}
\alias{bandleChain-class}
\alias{.bandleChain}
\alias{chains}
\alias{show,bandleParams-method}
\alias{show,nicheParam-method}
\alias{show,bandleChain-method}
\alias{length,bandleChains-method}
\alias{length,bandleParams-method}
\alias{length,bandleSummaries-method}
\alias{length,nicheParams-method}
\alias{posteriorEstimates}
\alias{posteriorEstimates,bandleSummary-method}
\alias{summaries}
\alias{params}
\alias{bandleJoint}
\alias{bandleJoint,bandleSummary-method}
\alias{[[,bandleChains,ANY,ANY-method}
\alias{[[,bandleParams,ANY,ANY-method}
\alias{[,bandleChains,ANY,ANY,ANY-method}
\alias{[,bandleParams,ANY,ANY,ANY-method}
\alias{show,bandleChains-method}
\alias{show,bandleSummaries-method}
\alias{[[,bandleSummaries,ANY,ANY-method}
\alias{[,bandleSummaries,ANY,ANY,ANY-method}
\alias{[[,nicheParams,ANY,ANY-method}
\alias{[,nicheParams,ANY,ANY,ANY-method}
\alias{show,nicheParams-method}
\title{Infrastructure to to store and process MCMC results}
\usage{
chains(object)

\S4method{show}{bandleParams}(object)

\S4method{show}{nicheParam}(object)

\S4method{show}{bandleChain}(object)

\S4method{length}{bandleChains}(x)

\S4method{length}{bandleParams}(x)

\S4method{length}{bandleSummaries}(x)

\S4method{length}{nicheParams}(x)

\S4method{length}{nicheParams}(x)

posteriorEstimates(object)

\S4method{posteriorEstimates}{bandleSummary}(object)

summaries(object)

params(object)

bandleJoint(object)

\S4method{bandleJoint}{bandleSummary}(object)

\S4method{[[}{bandleChains,ANY,ANY}(x, i, j = "missing", drop = "missing")

\S4method{[[}{bandleParams,ANY,ANY}(x, i, j = "missing", drop = "missing")

\S4method{[}{bandleChains,ANY,ANY,ANY}(x, i, j = "missing", drop = "missing")

\S4method{[}{bandleParams,ANY,ANY,ANY}(x, i, j = "missing", drop = "missing")

\S4method{show}{bandleChains}(object)

\S4method{show}{bandleSummaries}(object)

\S4method{[[}{bandleSummaries,ANY,ANY}(x, i, j = "missing", drop = "missing")

\S4method{[[}{bandleSummaries,ANY,ANY}(x, i, j = "missing", drop = "missing")

\S4method{[}{bandleSummaries,ANY,ANY,ANY}(x, i, j = "missing", drop = "missing")

\S4method{[[}{nicheParams,ANY,ANY}(x, i, j = "missing", drop = "missing")

\S4method{[[}{nicheParams,ANY,ANY}(x, i, j = "missing", drop = "missing")

\S4method{[}{nicheParams,ANY,ANY,ANY}(x, i, j = "missing", drop = "missing")

\S4method{show}{nicheParams}(object)
}
\arguments{
\item{object}{object of class nicheParams.}

\item{x}{Object to be subset.}

\item{i}{An \code{integer()}. Should be of length 1 for \code{[[}.}

\item{j}{Missing.}

\item{drop}{Missing.}
}
\value{
An object of class \code{bandleParams} which stores the main results
for the analysis when using bandle
}
\description{
The \code{bandleParams} infrastructure is used to store and process MCMC results for
bandle model from Crook et al 2021
}
\details{
Objects of the \code{bandleParams} class are created with the \code{bandle()} function
These objects store the \emph{priors} for the model and the results of the MCMC
chains, which themselves are stored as an instance of class \code{bandleChains} and
can be accessed with the \code{chains()} function. A summary of the \code{bandleChains}
(or class \code{bandleSummary}) can be further computed with the \code{bandleProcess}
function.

see the \emph{bandle} vignette for examples
}
\section{Slots}{

\describe{
\item{\code{chains}}{\code{list()} containing the individual full MCMC chain
results in an \code{bandleChains} instance. Each element must be a
valid \code{bandleChain} instance.}

\item{\code{posteriorEstimates}}{A \code{DataFrame} documenting the posteriors
in an \code{bandleSummary} instance}

\item{\code{diagnostics}}{A \code{matrix} of dimensions 1 by 2 containing the
\code{bandleSummary} diagnostics.}

\item{\code{bandle.joint}}{A \code{matrix} of dimensions N by K storing the joint
probability in an \code{bandleSummary} instance for each of the first condition}

\item{\code{chains}}{\code{list()} containing the individual bandle Summaries for
different conditions results in an \code{bandleSummaries} instance. Each element must be a
valid \code{bandleSummary} instance.}

\item{\code{method}}{A \code{character()} storing the bandle method name}

\item{\code{priors}}{A \code{list()} with the priors for the parameters}

\item{\code{seed}}{An \code{integer()} with the random number generation seed.}

\item{\code{summary}}{Object of class \code{bandleSummary} the summarised MCMC results
available in the \code{bandleParams} instance.}

\item{\code{chains}}{Object of class \code{bandleChains} containing the full MCMC results
in the \code{bandleParams} instance}

\item{\code{datset}}{\code{character} indicating which dataset i.e control or treatment}

\item{\code{replicate}}{\code{integer} an integer indicating which replicate}

\item{\code{K}}{\code{integer(1)} indicating the number of components.}

\item{\code{D}}{\code{integer(1)} indicating the number of samples.}

\item{\code{method}}{\code{character(1)} defining the method used. Currently
\code{bandle}}

\item{\code{mk}}{\code{matrix(K, D)}}

\item{\code{lambdak}}{\code{numeric(K)}}

\item{\code{nuk}}{\code{numeric(K)}}

\item{\code{sk}}{\code{array(K, D, D)}}

\item{\code{params}}{\code{list()} containing the individual \code{nicheParam} objects
results in an \code{bandleParams} instance. Each element must be a
valid \code{bandleParam} instance.}

\item{\code{dataset}}{\code{character} indicating the dataset usaully control or treatment}

\item{\code{replicate}}{\code{integer} indicating the number of dataset replicate}

\item{\code{n}}{\code{integer(1)} indicating the number of MCMC interactions.
Stored in an \code{bandleChain} instance.}

\item{\code{K}}{\code{integer(1)} indicating the number of components. Stored
in an \code{bandleChain} instance.}

\item{\code{N}}{\code{integer(1)} indicating the number of proteins. Stored in
an \code{bandleChain} instance.}

\item{\code{niche}}{\code{matrix(N, n)} component allocation results of an
\code{bandleChain} instance.}

\item{\code{nicheProb}}{\code{matrix(N, n, K)} component allocation
probabilities of an \code{bandleChain} instance.}

\item{\code{outlier}}{\code{matrix(N, n)} outlier allocation results.}

\item{\code{outlierProb}}{\code{matrix(N, n, 2)} outlier allocation
probabilities of an \code{bandleChain} instance.}
}}

