% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandle-function.R
\name{bandleProcess}
\alias{bandleProcess}
\title{process bandle results}
\usage{
bandleProcess(params)
}
\arguments{
\item{params}{An object of class \code{bandleParams}}
}
\value{
\code{bandleProcess} returns an instance of class
\code{bandleParams} with its summary slot populated.
}
\description{
process bandle results
}
\examples{
library(pRolocdata)
data("tan2009r1")
set.seed(1)
tansim <- sim_dynamic(object = tan2009r1, 
                    numRep = 6L,
                   numDyn = 100L)
gpParams <- lapply(tansim$lopitrep, function(x) 
fitGPmaternPC(x, hyppar = matrix(c(0.5, 1, 100), nrow = 1)))
d1 <- tansim$lopitrep
control1 <- d1[1:3]
treatment1 <- d1[4:6]
mcmc1 <- bandle(objectCond1 = control1, objectCond2 = treatment1, gpParams = gpParams,
                                     fcol = "markers", numIter = 5L, burnin = 1L, thin = 2L,
                                     numChains = 1, BPPARAM = SerialParam(RNGseed = 1))
mcmc1 <- bandleProcess(mcmc1)

}
