% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandle-utils.R
\name{EFDR}
\alias{EFDR}
\title{Compute the expected False Discovery Rate}
\usage{
EFDR(prob, threshold = 0.9)
}
\arguments{
\item{prob}{A numeric indicating probabilities of differential localisation}

\item{threshold}{A numeric indicating the probability threshold. The default
is 0.90.}
}
\value{
The expected false discovery rate for a given threshold
}
\description{
The EFDR for a given threshold is equal to the sum over all proteins
that exceed that threshold of one minus the posterior probability of
differential localisations, divides by the total number of proteins
with probabilities of differential localisation greater than that
threshold.
}
\examples{
library(pRolocdata)
data("tan2009r1")
set.seed(1)
tansim <- sim_dynamic(object = tan2009r1, 
                    numRep = 6L,
                   numDyn = 100L)
gpParams <- lapply(tansim$lopitrep, function(x) 
fitGPmaternPC(x, hyppar = matrix(c(0.5, 1, 100), nrow = 1)))
d1 <- tansim$lopitrep
control1 <- d1[1:3]
treatment1 <- d1[4:6]
mcmc1 <- bandle(objectCond1 = control1, objectCond2 = treatment1, gpParams = gpParams,
                                     fcol = "markers", numIter = 10L, burnin = 1L, thin = 2L,
                                     numChains = 1, BPPARAM = SerialParam(RNGseed = 1))
mcmc1 <- bandleProcess(mcmc1)
dp <- diffLocalisationProb(mcmc1)
EFDR(dp, threshold = 0.5)

}
