% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relabu_boxplot.R
\name{relabu_boxplot}
\alias{relabu_boxplot}
\title{Plot boxplots comparing different organism prevalence across conditions}
\usage{
relabu_boxplot(
  MAE,
  tax_level,
  condition,
  organisms = c(),
  datatype = c("counts", "relative abundance", "logcpm")
)
}
\arguments{
\item{MAE}{A multi-assay experiment object}

\item{tax_level}{The taxon level used for organisms}

\item{condition}{Compare groups by condition e.g. 'SEX'}

\item{organisms}{Include organisms for plotting.}

\item{datatype}{counts, relative abundance,logcpm}
}
\value{
A plotly object
}
\description{
Plot boxplots comparing different organism prevalence across conditions
}
\examples{
data_dir <- system.file("extdata/MAE.rds", package = "animalcules")
toy_data <- readRDS(data_dir)
p <- relabu_boxplot(toy_data,
  tax_level = "genus",
  organisms = c("Escherichia", "Actinomyces"),
  condition = "SEX",
  datatype = "logcpm"
)
p

}
