## animalcules <img src="https://github.com/wejlab/materials/blob/master/animalcules/animalcules_logo.png?raw=true" align="right" width="170" />


[![](https://img.shields.io/badge/Bioconductor-3.14-blue)](https://doi.org/doi:10.18129/B9.bioc.animalcules)
[![](https://img.shields.io/badge/platforms-linux%20%7C%20osx%20%7C%20win-2a89a1.svg)](http://bioconductor.org/checkResults/release/bioc-LATEST/animalcules/)
[![](https://img.shields.io/github/last-commit/wejlab/animalcules.svg)](https://github.com/wejlab/animalcules/commits/master)
[![](https://img.shields.io/badge/lifecycle-steady-blue.svg)](https://www.tidyverse.org/lifecycle/#maturing)
[![](https://bioconductor.org/shields/build/release/bioc/animalcules.svg)](http://bioconductor.org/checkResults/release/bioc-LATEST/animalcules/)

## What does animalcules do?

**R shiny app for interactive microbiome analysis**

animalcules is an R package for utilizing up-to-date data analytics, visualization methods, and machine learning models to provide users an easy-to-use interactive microbiome analysis framework. It can be used as a standalone software package or users can explore their data with the accompanying interactive R Shiny application. 

Traditional microbiome analysis such as alpha/beta diversity and differential abundance analysis are enhanced, while new methods like biomarker identification are introduced by animalcules. Powerful interactive and dynamic figures generated by animalcules enable users to understand their data better and discover new insights. 

## Documentation

Please check our website at https://wejlab.github.io/animalcules-docs/


## Citation

Our paper on animalcules was published on the journal <strong>Microbiome</strong> in 2021!

You can find our paper here: 
https://microbiomejournal.biomedcentral.com/articles/10.1186/s40168-021-01013-0

Please cite:

<strong>Zhao, Y., Federico, A., Faits, T., Manimaran, S., Segrè, D., Monti, S. and Johnson, W.E., 2021. animalcules: interactive microbiome analytics and visualization in R. Microbiome, 9(1), pp.1-16.</strong>


## Before Installation

* Make sure R version is >= 4.3.0 and Bioconductor version is 3.18. Bioconductor could be updated by :

``` r
if (!requireNamespace("BiocManager", quietly = TRUE))
    install.packages("BiocManager")
BiocManager::install(version = "3.18")
```

## Installation


* Install the release version of the package from Bioconductor

``` r
if (!requireNamespace("BiocManager", quietly=TRUE))
  install.packages("BiocManager")
BiocManager::install("wejlab/animalcules")

```

* Install the development version of the package from Github 

``` r
if (!requireNamespace("devtools", quietly=TRUE))
  install.packages("devtools")
devtools::install_github("wejlab/animalcules")
```

Run the animalcules shiny app!

``` r
library(animalcules)
run_animalcules()
```

## Installing w/ Docker

First, make sure you have [Docker installed](https://docs.docker.com/get-docker/) on your machine.

* Pull the pre-built Docker image

```
docker pull bucbm/animalcules:latest
```

* Or if you'd like to build the Docker image from scratch

``` bash
git clone https://github.com/wejlab/animalcules
cd animalcules
docker build --tag bucbm/animalcules:latest .
```

* Run with Docker
``` bash
docker run -d -p 8787:8787 -e PASSWORD=animalcules bucbm/animalcules:latest
```

* Go to http://localhost:8787/ in browser and enter username: rstudio / password: animalcules. Then enter the following:  

``` r
library(animalcules)
run_animalcules()
```
