% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_general.R
\name{getEvents}
\alias{getEvents}
\title{Transform aligned strings into GRanges representation of events.}
\usage{
getEvents(
  pattern,
  subject,
  scores,
  ID = "NA",
  ampl_shift = 1L,
  ampl_start = 1L,
  strand_info = "+"
)
}
\arguments{
\item{pattern}{(character) Aligned pattern.}

\item{subject}{(character) Aligned subject.}

\item{scores}{(integer) Alignment scores of the pattern and subject.}

\item{ID}{(character) Will be used as seqnames of output GRanges.}

\item{ampl_shift}{(numeric) Possible shift of the amplicons.}

\item{ampl_start}{(numeric) Real amplicon starts.
\code{\link[pwalign]{pairwiseAlignment}} clips alignments, therefore to output
GRanges relative to the amplicon sequence (subject) ranges have to be
shifted.}

\item{strand_info}{(character) Strands to assign.}
}
\value{
(\code{\link[GenomicRanges]{GRanges}}) Same as events.
}
\description{
Transforms aligned strings into GRanges representation with
events of deletions, insertions and mismatches. Subject should come from
one amplicon sequence, after alignment to many sequences (patterns).
}
