% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixFromSCE.R
\name{matrixFromSCE}
\alias{matrixFromSCE}
\title{Returns the RNA expression matrix from a SingleCellExperiment
with unique hgnc gene names in columns}
\usage{
matrixFromSCE(sce)
}
\arguments{
\item{sce}{SingleCellExperiment object to convert}
}
\value{
the RNA expression matrix from a SingleCellExperiment
with unique hgnc gene names in columns
}
\description{
Returns the RNA expression matrix from a SingleCellExperiment
with unique hgnc gene names in columns
}
\details{
This function retrieves from a SingleCellExperiment
object the raw RNA expression value corresponding to the hgnc
genes. The resulting matrix can then be used with adverSCarial
packages.
}
\examples{
library(TENxPBMCData)

pbmc <- TENxPBMCData(dataset = "pbmc3k")
mat_rna <- matrixFromSCE(pbmc)

}
