% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/advRandWalkMinChange.R
\name{advRandWalkMinChange}
\alias{advRandWalkMinChange}
\title{Random walk search of min change adversarial attack.}
\usage{
advRandWalkMinChange(
  exprs,
  clusters,
  target,
  classifier,
  genes,
  modifications = list(c("perc1"), c("perc99")),
  firstBatch = 100,
  walkLength = 100,
  stepChangeRatio = 0.2,
  whileMaxCount = 10000,
  changeType = "any",
  argForClassif = "data.frame",
  argForModif = "data.frame",
  verbose = FALSE
)
}
\arguments{
\item{exprs}{DelayedMatrix of numeric RNA expression, cells are rows and genes
are columns - or a SingleCellExperiment object, a matrix or a data.frame. By
default matrix and data.frame are converted to DelayedMatrix for memory
performance, see 'argForModif' argument for options.}

\item{clusters}{a character vector of the clusters to which the cells belong}

\item{target}{the name of the cluster to modify}

\item{classifier}{a classifier in the suitable format.
A classifier function should be formated as follow:
classifier = function(expr, clusters, target){
# Making the classification
c("cell type", score)
}
\code{score} should be numeric between 0 and 1, 1 being the highest confidance
into the cell type classification.
The matrix \code{expr} contains RNA expression values, the vector \code{clusters}
consists of the cluster IDs for each cell in \code{expr}, and \code{target} is the
ID of the cluster for which we want to have a classification.
The function returns a vector with the classification result, and a score.}

\item{genes}{the character vector of genes to study}

\item{modifications}{the list of the modifications to study}

\item{firstBatch}{the maximum number of try in step 1}

\item{walkLength}{the maximum number of try in step 2}

\item{stepChangeRatio}{ratio of parameters change in new walk step}

\item{whileMaxCount}{the maximum number of try when looking
for new combination of parameters}

\item{changeType}{\code{any} consider each misclassification,
\code{not_na} consider each misclassification but NA.}

\item{argForClassif}{the type of the first argument to feed to the
classifier function. 'data.frame' by default, can be 'SingleCellExperiment'
or 'DelayedMatrix'.}

\item{argForModif}{type of matrix during for the modification, 'data.frame'
by default. Can be 'DelayedMatrix', which needs less memory but is slower.}

\item{verbose}{logical, set to TRUE to activate verbose mode}
}
\value{
DataFrame results of the classification of all the grid combinations
}
\description{
Random walk search of min change adversarial attack.
}
\details{
The parameter search by grid can take a long time,
this function aims to make a parameter search faster.
We have a function, advSingleGene, looking for one gene attacks.
The advRandWalkMinChange function aims to find a multiple genes
attack, with the fewer genes possible.
At first the user have to provide a list of genes to test, for
example by running differential statistics between two cell clusters.
The user should also provide a list of modifications to test, to
define as so - each item of the list should be 1 or 2 length size.
The 1 length vector must contain the prerecorded modifications, 'perc1'
or 'perc99'.
The 2 length vector must have as first item:
\itemize{
\item 'fixed', in this case the second item should be the value to be
replaced by.
\item 'full_row_fct', 'target_row_fct', 'target_matrix_fct' or
'full_matrix_fct'. In this case the second item should be a function.
Let's say we want to analysis the susceptibility to min change attack
for 3 modifications: "perc1", the modification of each value of the
cluster by 1000, and a custom modification stored inside a function myFct.
Then the 'modification' parameter should be:
my_modifications = list(c("perc1"),
c("fixed", 1000),
c("full_matrix_fct", myFct))
}

Then the function will try to find the best combination of these genes
and modifications to make the min change attack.
Step 1 is to find a seed by trying random combinations of
genes and modifications on a cluster until the classification is altered.
Step 2 is to perform a random walk search to reduce the number of genes
needed to change the classification.
The
}
\examples{
library(DelayedArray)

MyClassifier <- function(expr, clusters, target) {
   c("T cell", 0.9)
}
rna_expression <- DelayedArray(data.frame(CD4=c(0,0,0,0), CD8A=c(1,1,1,1),
     CD8B=c(2,2,3,3)))
genes <- c("CD4", "CD8A")
clusters_id <- c("B cell","B cell","T cell","T cell")

advRandWalkMinChange(rna_expression, clusters_id, "T cell",
MyClassifier, genes=genes,
modifications = list(c("perc1"), c("perc99")))

# Stop at first attack discovery, whitout going into the walk
# parameter search.
advRandWalkMinChange(rna_expression, clusters_id, "T cell",
 MyClassifier, genes=genes,
 modifications = list(c("perc1"), c("perc99")), walkLength=0)

myModif = function(x, y){
   return(sample(1:10,1))
}

my_modifications = list(c("perc1"),
                        c("fixed", 1000),
                        c("full_matrix_fct", myModif))
advRandWalkMinChange(rna_expression, clusters_id, "T cell",
 MyClassifier, genes=genes, modifications = my_modifications)
}
