% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/advModifications.R
\name{advModifications}
\alias{advModifications}
\title{Returns a modified RNA expression DelayedMatrix, or a modified SingleCellExperiment,
for a given cluster, for a given modification.}
\usage{
advModifications(
  exprs,
  genes,
  clusters,
  target,
  advMethod = "perc99",
  advFixedValue = 3,
  advFct = NULL,
  argForClassif = "DelayedMatrix",
  argForModif = "data.frame",
  slot = NULL,
  verbose = FALSE
)
}
\arguments{
\item{exprs}{DelayedMatrix of numeric RNA expression, cells are rows and genes
are columns - or a SingleCellExperiment object, a matrix or a data.frame. By default,
these are converted to a data.frame to increase speed performance during modifications.
However, this conversion can consume a significant amount of memory, see 'argForModif'
argument for options.}

\item{genes}{the character vector of genes to modify}

\item{clusters}{a character vector of the clusters to which the cells belong}

\item{target}{the name of the cluster to modify}

\item{advMethod}{the name of the method to use}

\item{advFixedValue}{the numeric value to use in case of
advMethod=\code{fixed}}

\item{advFct}{the function to use in case advMethod
belongs to the following list: \code{full_row_fct}, \code{target_row_fct},
\code{target_matrix_fct}, \code{full_matrix_fct}}

\item{argForClassif}{the type of the first argument to feed to the
classifier function. 'DelayedMatrix' by default, can be 'SingleCellExperiment'
or 'data.frame'.}

\item{argForModif}{type of matrix during for the modification, 'DelayedMatrix'
by default. Can be 'data.frame', which is faster, but need more memory.}

\item{verbose}{logical, set to TRUE to activate verbose mode}
}
\value{
the matrix or a data.frame exprs modified on asked genes
with the specified modification
}
\description{
Returns a modified RNA expression DelayedMatrix, or a modified SingleCellExperiment,
for a given cluster, for a given modification.
}
\details{
The motivation for this function is to standardize the modifications
we want to study in the attacks. We give as argument a DelayedMatrix of the RNA
expression, the gene and the target cells we want to modify. Then we have
three arguments allowing to specify what modification we want to apply on
these cells. The advMethod contains, a specific prerecorded modification
or an indication on how to use the other two arguments.
The prerecorded modifications available for the advMethod argument are:
\itemize{
\item 'perc1', replace the value by the whole matrix 1 percentile value of
the gene. It is as if we biologically switched off the gene.
\item 'perc99', replace the value by the whole matrix 99 percentile value of
the gene. It is as if we biologically switched on the gene to the maximum.
\item 'random', replace the value by from a uniform distribution between min
and max of the gene on the dataset
\item 'positive_aberrant' replace value by 10,000 times the max value of the
gene on the dataset
\item 'negative_aberrant' replace value by -10,000 times the max value of the
gene on the dataset
\item 'decile+X', shifts the gene value by + X deciles.
\item 'decile-X', shifts the gene value by - X deciles.
The value of the advMethod argument can also be 'fixed', in this case the
modification would be to replace the value of the gene of the wanted cells
by the value of the argument 'advFixedValue'. This can be useful to test
aberrant values like negative integer, absurdly high values of character
values.
The value of the advMethod argument can also be 'full_row_fct',
'target_row_fct', 'target_matrix_fct' or 'full_matrix_fct'. They are
used when we want to use a custom modification function, with the 'advFct'
argument:
\item 'full_row_fct' indicate that the 'advFct' function takes the whole gene
values as input.
\item 'target_row_fct' indicate that the 'advFct' function takes target cells
gene values as input.
\item 'full_matrix_fct' indicate that the 'advFct' function takes the whole gene
expression values as input.
\item 'target_matrix_fct' indicate that the 'advFct' function takes target cells
all genes values as input.
}
}
\examples{
library(DelayedArray)

rna_expression <- DelayedArray(data.frame(CD4=c(0,0,0,0), CD8A=c(1,1,1,1),
     CD8B=c(2,2,3,3)))
genes <- c("CD4", "CD8A")
clusters_id <- c("B cell","B cell","T cell","T cell")

advModifications(rna_expression, genes, clusters_id,
"T cell", advMethod="perc99")
}
