% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MClassifier.R
\name{MClassifier}
\alias{MClassifier}
\title{Example cell type classifier for pbmc clustered datasets.}
\usage{
MClassifier(exprs, clusters, target)
}
\arguments{
\item{exprs}{DelayedMatrix of numeric RNA expression, cells are rows and genes
are columns - or a SingleCellExperiment object, a matrix or a data.frame.}

\item{clusters}{vector of clusters to which each cell belongs}

\item{target}{name of the cell cluster to classify}
}
\value{
a vector with the classification, and the odd
}
\description{
Example cell type classifier for pbmc clustered datasets.
}
\details{
This classifier aims at testing the adverSCarial
package of real pbmc data. It is a simple marker based
classifier. It looks at the average value of a few genes
inside a cluster, and returns the associated cell type.
Markers where found by differential expressions.
}
\examples{
library(TENxPBMCData)

pbmc <- TENxPBMCData(dataset = "pbmc3k")
mat_rna <- matrixFromSCE(pbmc)
cell_types <- system.file("extdata",
    "pbmc3k_cell_types.tsv",
    package = "adverSCarial"
)
cell_types <- read.table(cell_types, sep = "\t")$cell_type

MClassifier(mat_rna, cell_types, "DC")

}
