% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\docType{methods}
\name{selectTrajectory}
\alias{selectTrajectory}
\alias{selectTrajectory,SingleCellExperiment-method}
\title{Select component from trajectory graph}
\usage{
selectTrajectory(sce, component)
}
\arguments{
\item{sce}{A \code{SingleCellExperiment} object}

\item{component}{Number of component to be selected}
}
\value{
An updated \code{SingleCellExperiment} object
}
\description{
Retains a single component of a trajectory graph.
}
\details{
The construction of a trajectory graph may result in a forest
having multiple tree components, which may represent individual
trajectories or isolated nodes. This method should be used to extract a
single component from the graph. A component is
identified by its (integer) number.
\cr \cr
\emph{Diagnostic messages}
\cr \cr
An error is thrown if the states have not been connected yet;
function \code{connectStates} needs to be called first. An
error is thrown if an unknown component (number) is selected.
}
\examples{
# Example data
data(exSCE)

# Select trajectory
exSCE <- selectTrajectory(exSCE, component=1)
}
\seealso{
\code{connectStates}

\code{findStates} \code{states}
}
\author{
Daniel C. Ellwanger
}
