% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\docType{methods}
\name{plotTrail}
\alias{plotTrail}
\alias{plotTrail,SingleCellExperiment-method}
\title{Visualize single trails}
\usage{
plotTrail(sce, name)
}
\arguments{
\item{sce}{A \code{SingleCellExperiment} object}

\item{name}{Name of the trail}
}
\value{
A \code{ggplot} object
}
\description{
Method highlights a single trail on the trajectory map
}
\details{
A trail can be defined with the function \code{addTrail} between
two landmarks. User-defined landmarks can be set with the function
\code{userLandmarks}. This function visualizes the start and endpoints, and
the pseudotime of a defined trail along the trajectory. The trail
pseudotimes can be directly accessed via the \code{trails}.
\cr\cr
An error is thrown if the \code{trail_name} is unknown. The function is
case-sensitiv. All available trails can be listed by \code{trailNames}.
}
\examples{
# Example data
data(exSCE)

# Plot trail
plotTrail(exSCE, name="Tr1")
}
\seealso{
\code{addTrail} \code{userLandmarks} \code{trailNames}
\code{trails}
}
\author{
Daniel C. Ellwanger
}
