% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\docType{methods}
\name{plotStateTrajectory}
\alias{plotStateTrajectory}
\alias{plotStateTrajectory,SingleCellExperiment-method}
\title{Visualize state trajectory graph}
\usage{
plotStateTrajectory(
  sce,
  color_by = c("phenoName", "featureName"),
  name,
  component = NULL,
  point_size = 3,
  label_offset = 2,
  recalculate = FALSE
)
}
\arguments{
\item{sce}{A \code{SingleCellExperiment} object}

\item{color_by}{Indicates if nodes are colorized by a feature expression
('featureName') or phenotype label ('phenoName')}

\item{name}{A character string specifying the featureName or phenoName}

\item{component}{Component of trajectory graph that should
be shown (integer value)}

\item{point_size}{Adjusts the point size of the data points shown}

\item{label_offset}{Adjusts the offset of the data point labels}

\item{recalculate}{If layout should be re-drawn (default: FALSE)}
}
\value{
A \code{ggplot} object
}
\description{
Method visualizes the state-to-state relations delineating the
trajectory backbone.
}
\details{
Shows a single tree component of the computed trajectory graph.
Each point in this plot represents a state and can be colorized
according to feature expression (mean expression per state) or experimental
metadata (arithmetic mean or percentage distribution of categorial values).
The component is defined by parameter \code{component}. If the trajectory
graph contains only a single component, then this parameter can be left
undefined. The points' coloration can be defined via the attributes
\code{color_by} and \code{name}, respectively. Missing sample lables are
recovered using nearest neighbor learning. \cr
If the state trajectory graph layout was set with \code{stateTrajLayout<-}
then the layout will be reused for visualization.
}
\examples{
# Example data
data(exSCE)

plotStateTrajectory(exSCE, color_by="phenoName", name="age",
                    component=1, point_size = 1.5, label_offset = 4)

gp <- plotStateTrajectory(exSCE, color_by="featureName", name="feature_1",
                          component=1, recalculate=TRUE)
stateTrajLayout(exSCE) <- gp
}
\seealso{
\code{connectStates}
}
\author{
Daniel C. Ellwanger
}
