% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessor-methods.R
\docType{methods}
\name{addTrail}
\alias{addTrail}
\alias{addTrail,SingleCellExperiment-method}
\title{ADD trail}
\usage{
addTrail(sce, from, to, name)
}
\arguments{
\item{sce}{An object of class \code{SingleCellExperiment}}

\item{from}{Start landmark}

\item{to}{End landmark}

\item{name}{Name of trail}
}
\value{
An updated object of class \code{SingleCellExperiment}
}
\description{
Function to define a single trail on the trajectory.
}
\details{
A trajectory can be composed of multiple single trails
(e.g., developmental progression from a common start towards
distinct terminal phenotypes). Start and endpoints of trails can
be identified visually using the plot function \code{plotMap}.
Here, start (=from) and end (=to) IDs
of landmarks are starting with the character "B"
(for branching points), "H" (for trail heads, i.e. terminal nodes),
and "U" for user-defined landmarks.
\cr \cr
\emph{Diagnostic messages}
\cr \cr
An error is thrown if the trajectory has not been fitted yet. Please,
call \code{fitTrajectory} first. Further, an error is thrown if the
provided start or end ID is unknown. A warning is
shown if a trail with the same name already exists and gets
re-defined.
}
\examples{
# Example data
data(exSCE)

# Add trail
exSCE <- addTrail(exSCE, "H1", "H2", "Tr3")
trailNames(exSCE)
phenoNames(exSCE)
}
\seealso{
\code{fitTrajectory} \code{landmarks} \code{plotMap}
}
\author{
Daniel C. Ellwanger
}
