% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunction.R
\name{targetGeneSpectrumPlot}
\alias{targetGeneSpectrumPlot}
\title{Bar-chart to show the hosting gene types of binding sites}
\usage{
targetGeneSpectrumPlot(object, showNGroups = 5, text.size = 4)
}
\arguments{
\item{object}{a \code{\link{BSFDataSet}} object}

\item{showNGroups}{numeric; the number of different gene types to show}

\item{text.size}{numeric; the size of the text elments on the plot}
}
\value{
a plot of type \code{\link{ggplot}}
}
\description{
A diagnostic function that plots the gene type of the hosting gene for
each binding site. The function \code{\link{assignToGenes}} is expected to be
executed prior to calling this plot function.
}
\examples{
# load clip data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))
load(list.files(files, pattern = ".rds$", full.names = TRUE)[1])
bds = makeBindingSites(object = bds, bsSize = 9)
bds = assignToGenes(bds, anno.genes = gns)
targetGeneSpectrumPlot(bds)

}
\seealso{
\code{\link{assignToGenes}} \code{\link{geneOverlapsPlot}}
}
