% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\docType{methods}
\name{getMeta}
\alias{getMeta}
\alias{getMeta,BSFDataSet-method}
\title{Accessor method for the meta data of the BSFDataSet object}
\usage{
getMeta(object)

\S4method{getMeta}{BSFDataSet}(object)
}
\arguments{
\item{object}{a BSFDataSet object}
}
\value{
returns the meta data \code{data.frame} with the columns "condition",
"clPlus" and "clMinus".
}
\description{
Meta data is stored as a \code{data.frame} and must contain the columns
"condition", "clPlus" and "clMinus".
}
\examples{

# load data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))

getMeta(bds)

}
\seealso{
\code{\link{BSFDataSet}}
}
