% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coveragePlots.R
\name{bindingSiteCoveragePlot}
\alias{bindingSiteCoveragePlot}
\title{Plot signal coverage of selected ranges}
\usage{
bindingSiteCoveragePlot(
  object,
  plotIdx,
  flankPos,
  shiftPos = NULL,
  mergeReplicates = FALSE,
  autoscale = FALSE,
  highlight = TRUE,
  showCentralRange = TRUE,
  customRange = NULL,
  customRange.name = "custom",
  customAnnotation = NULL,
  customAnnotation.name = "anno",
  title = NULL,
  colorPalette = NULL
)
}
\arguments{
\item{object}{a \link{BSFDataSet} object}

\item{plotIdx}{integer, index of the range to plot}

\item{flankPos}{numeric, number of nucleotides by which the plotting frame is
symmetrically extended}

\item{shiftPos}{numeric, nucleotide positions by which the current plotting
range should be shifted}

\item{mergeReplicates}{logical, if replicates should be merge per
condition (TRUE) or if every replicates should be shown separately (FALSE)}

\item{autoscale}{logical, if y-axis should be scaled to the maximum for all
replicates (TRUE), or not (FALSE)}

\item{highlight}{logical, if the central range should be highlighted (TRUE),
or not (FALSE)}

\item{showCentralRange}{logical, if the central range should be shown (TRUE),
or not (FALSE)}

\item{customRange}{\code{GenomicRanges}, a custom range object to be shown
underneath the coverage tracks}

\item{customRange.name}{character, the name of the customRange track}

\item{customAnnotation}{\code{GenomicRanges} or \code{TxDb}, a custom annotation
for eg. gene, exons, etc. to be shown underneath the coverage tracks}

\item{customAnnotation.name}{character, the name of the customAnnotation track}

\item{title}{character, set plotting title}

\item{colorPalette}{vector, hex colors used for the conditions}
}
\value{
an object of class \code{GVIZ}
}
\description{
Function plots the coverage of the CLIP data in the signal slot and plots it
as coverage. The plot is centered around a given binding site, which can be
selected by an index.
}
\examples{
# load data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))

bindingSiteCoveragePlot(bds, plotIdx = 3, flankPos = 10)

}
\seealso{
\code{\link{BSFDataSet}}, \code{\link{BSFind}}
}
