% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_statistic.R
\name{compute_lambda}
\alias{compute_lambda}
\title{Compute the lambda index for determining a need for batch correction}
\usage{
compute_lambda(dat, batchind, groupind)
}
\arguments{
\item{dat}{Numeric matrix of dimension (genes x samples) where each row
represents one gene's expression across samples.}

\item{batchind}{Factor or numeric vector of length = ncol(dat); batch
indicator for each sample}

\item{groupind}{Factor or numeric vector of length = ncol(dat); biological
group label/indicator for each sample.}
}
\value{
dataframe with columns:
\describe{
\item{BatchV}{Proportion of total variance explained by batch effects.}
\item{GroupV}{Proportion of total variance explained by group effects.}
\item{ResidV}{Proportion of total variance that is residual noise.}
\item{lambda_raw}{Raw lambda index = total SS_batch / total SS_group.}
\item{lambda_adj}{Adjusted lambda = lambda_raw * ResidV/(1-ResidV).}
}
}
\description{
This function calculates the proportions of variation explained by batch,
group, and residual for each gene using two-way ANOVA and computes the lambda
index based on these three proportions.
}
\examples{

library(scran)
se <- mockSCE()
res <- BatchQC::compute_lambda(assays(se)[["counts"]],
  colData(se)$Mutation_Status,
  colData(se)$Treatment)
print(res)

}
