% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_correction.R
\name{batch_correct}
\alias{batch_correct}
\title{Batch Correct
This function allows you to Add batch corrected count matrix to the SE object}
\usage{
batch_correct(se, method, assay_to_normalize, batch, group = NULL,
covar, output_assay_name, ...)
}
\arguments{
\item{se}{SummarizedExperiment object}

\item{method}{Normalization Method ("ComBat-Seq", "ComBat", "limma", "sva",
svaseq)}

\item{assay_to_normalize}{Which assay use to do normalization}

\item{batch}{The batch}

\item{group}{The group variable}

\item{covar}{list of covariates}

\item{output_assay_name}{name of results assay}

\item{...}{Arguments to be passed to specific methods, such as \code{num_sv} for
\code{svaseq_correction} and \code{psva} for \code{sva_correction}.}
}
\value{
a summarized experiment object with normalized assay appended
}
\description{
Batch Correct
This function allows you to Add batch corrected count matrix to the SE object
}
\examples{
library(scran)
se <- mockSCE()
se <- BatchQC::batch_correct(se, method = "ComBat-Seq",
                                    assay_to_normalize = "counts",
                                    batch = "Mutation_Status",
                                    covar = "Treatment",
                                    output_assay_name =
                                        "ComBat_Seq_Corrected")
se <- BatchQC::batch_correct(se, method = "ComBat",
                                    assay_to_normalize = "counts",
                                    batch = "Mutation_Status",
                                    covar = "Treatment",
                                    output_assay_name =
                                        "ComBat_Corrected")
se

}
