% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Assessment-class.R
\name{as.matrix.Assessment}
\alias{as.matrix.Assessment}
\title{Tabulate the Category Assignments for Assessment Results Objects}
\usage{
\method{as.matrix}{Assessment}(x, ...)
}
\arguments{
\item{x}{An object of class \code{Assessment} and subclass \code{Results}.}

\item{...}{Additional arguments.}
}
\value{
A one-row matrix with the counts for the number of genes/ORFs that fall into each category. The corresponding
category codes serve as the column names, and the name of the row is the strain ID.
}
\description{
The \code{as.matrix} method for \code{Assessment} and subclass \code{Results} objects
}
\details{
\code{as.matrix.Assessment} tabulates and returns the number of times each category appears in the \code{CategoryAssignments}
vector within the given \code{Results} object. If the number of genes for any the 14 main gene / ORF categories is zero, a
count (of zero) will still be included for that category.
}
\examples{

as.matrix(readRDS(system.file("extdata",
                              "MGAS5005_PreSaved_ResultsObj_Prodigal.rds",
                              package = "AssessORF")))

}
\seealso{
\code{\link{Assessment-class}}
}
