% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapbias-methods.R
\docType{methods}
\name{randomRef}
\alias{randomRef}
\alias{randomRef,ASEset-method}
\title{Random ref allele from genotype}
\usage{
randomRef(x, ...)

\S4method{randomRef}{ASEset}(x, source = "alleleCounts", ...)
}
\arguments{
\item{x}{\code{ASEset} object}

\item{...}{internal arguments}

\item{source}{'alleleCounts'}
}
\description{
Create a vector of random reference alleles
}
\details{
Randomly shuffles which of the two alleles for each genotype that is 
indicated as reference allele, based on either allele count information
or previous ref and alt alleles.

When the source is 'alleleCounts', the two most expressed alleles are taken
as reference and alternative allele.
}
\examples{

#load example data
data(ASEset.sim)
a <- ASEset.sim

ref(a) <- randomRef(a, source = 'alleleCounts') 

}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{mapbias}
