% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxillary-methods.R
\docType{methods}
\name{makeMaskedFasta}
\alias{makeMaskedFasta}
\alias{makeMaskedFasta,character-method}
\title{makes masked fasta reference}
\usage{
makeMaskedFasta(fastaIn, ...)

\S4method{makeMaskedFasta}{character}(
  fastaIn,
  fastaOut,
  posToReplace,
  splitOnSeqlevels = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{fastaIn}{character string of the path for the fasta file to be used}

\item{...}{arguments to pass on}

\item{fastaOut}{character string of the path for the masked fasta file (no extension)}

\item{posToReplace}{GRanges object with the genomic ranges to replace}

\item{splitOnSeqlevels}{write on file for each seqlevel to save memory}

\item{verbose}{makes function more talkative}
}
\description{
Replaces all selected positions in a fasta file with the character N
}
\examples{

data(ASEset.sim)
gr <- rowRanges(ASEset.sim)
fastaIn <- system.file('extdata/hg19.chr17.subset.fa', package='AllelicImbalance')
makeMaskedFasta(fastaIn=fastaIn, fastaOut="fastaOut",posToReplace=gr)


}
\author{
Jesper R. Gadin
}
\keyword{fasta}
\keyword{masked}
\keyword{reference}
