% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize-methods.R
\name{initialize-ASEset}
\alias{initialize-ASEset}
\alias{ASEsetFromCountList}
\alias{ASEsetFromArrays}
\title{Initialize ASEset}
\usage{
ASEsetFromCountList(
  rowRanges,
  countListUnknown = NULL,
  countListPlus = NULL,
  countListMinus = NULL,
  colData = NULL,
  mapBiasExpMean = NULL,
  phase = NULL,
  aquals = NULL,
  verbose = FALSE,
  ...
)

ASEsetFromArrays(
  rowRanges,
  countsUnknown = NULL,
  countsPlus = NULL,
  countsMinus = NULL,
  colData = NULL,
  mapBiasExpMean = NULL,
  phase = NULL,
  genotype = NULL,
  aquals = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{rowRanges}{A \code{GenomicRanges object} that contains the variants of
interest}

\item{countListUnknown}{A \code{list} where each entry is a matrix with
allele counts as columns and sample counts as rows}

\item{countListPlus}{A \code{list} where each entry is a matrix with allele
counts as columns and sample counts as rows}

\item{countListMinus}{A \code{list} where each entry is a matrix with allele
counts as columns and sample counts as rows}

\item{colData}{A \code{DataFrame} object containing sample specific data}

\item{mapBiasExpMean}{A 3D \code{array} where the SNPs are in the 1st
dimension, samples in the 2nd dimension and variants in the 3rd dimension.}

\item{phase}{A \code{matrix} or an \code{array} containing phase information.}

\item{aquals}{A 4-D array containing the countinformation, see details}

\item{verbose}{Makes function more talkative}

\item{...}{arguments passed on to SummarizedExperiment constructor}

\item{countsUnknown}{An array containing the countinformation}

\item{countsPlus}{An array containing the countinformation}

\item{countsMinus}{An array containing the countinformation}

\item{genotype}{matrix}
}
\value{
\code{ASEsetFromCountList} returns an \code{ASEset} object.
}
\description{
Functions to construct ASEset objects
}
\details{
The resulting ASEset object is based on the RangedSummarizedExperiment
class, and will therefore inherit the same accessors and ranges operations.

If both countListPlus and countListMinus are given they will be used to 
calculate countListUnknown, which is the sum of the plus and minus strands.

countListPlus, countListMinus and countListUnknown are
i.e. the outputs from the getAlleleCounts function.

aquals is new for the devel branch and will be changed slighly before the relase 
to include better granularity.
}
\note{
\code{ASEsetFromCountList} requires the same input data as a
RangedSummarizedExperiment, but with minimum one assay for the allele counts.
}
\examples{

#make example alleleCountListPlus
set.seed(42)
countListPlus <- list()
snps <- c('snp1','snp2','snp3','snp4','snp5')
for(snp in snps){
count<-matrix(rep(0,16),ncol=4,dimnames=list(
c('sample1','sample2','sample3','sample4'),
c('A','T','G','C')))
#insert random counts in two of the alleles 
for(allele in sample(c('A','T','G','C'),2)){
count[,allele]<-as.integer(rnorm(4,mean=50,sd=10))
}
countListPlus[[snp]] <- count
}

#make example alleleCountListMinus
countListMinus <- list()
snps <- c('snp1','snp2','snp3','snp4','snp5')
for(snp in snps){
count<-matrix(rep(0,16),ncol=4,dimnames=list(
c('sample1','sample2','sample3','sample4'),
c('A','T','G','C')))
#insert random counts in two of the alleles 
for(allele in sample(c('A','T','G','C'),2)){
count[,allele]<-as.integer(rnorm(4,mean=50,sd=10))
}
countListMinus[[snp]] <- count
}


#make example rowRanges
rowRanges <- GRanges(
seqnames = Rle(c('chr1', 'chr2', 'chr1', 'chr3', 'chr1')),
         ranges = IRanges(1:5, width = 1, names = head(letters,5)),
         snp = paste('snp',1:5,sep='')
         )
#make example colData
colData <- DataFrame(Treatment=c('ChIP', 'Input','Input','ChIP'), 
 row.names=c('ind1','ind2','ind3','ind4'))

#make ASEset 
a <- ASEsetFromCountList(rowRanges, countListPlus=countListPlus, 
countListMinus=countListMinus, colData=colData)

}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{ASEset}
\keyword{ASEsetFromCountList}
