% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxillary-methods.R
\docType{methods}
\name{getDefaultMapBiasExpMean}
\alias{getDefaultMapBiasExpMean}
\alias{getDefaultMapBiasExpMean3D}
\alias{getDefaultMapBiasExpMean,ANY-method}
\alias{getDefaultMapBiasExpMean3D,ANY-method}
\alias{getDefaultMapBiasExpMean,list-method}
\title{Map Bias}
\usage{
getDefaultMapBiasExpMean(alleleCountList, ...)

getDefaultMapBiasExpMean3D(alleleCountList, ...)

\S4method{getDefaultMapBiasExpMean}{list}(alleleCountList)

\S4method{getDefaultMapBiasExpMean3D}{ANY}(alleleCountList)
}
\arguments{
\item{alleleCountList}{A \code{GRangesList object} containing read
information}

\item{...}{parameters to pass on}
}
\value{
\code{getDefaultMapBiasExpMean} returns a matrix with a default
expected mean of 0.5 for every element.
}
\description{
an allele frequency array
}
\details{
This function will assume there is no bias that comes from the mapping of
reads, and therefore create a matrix with expected frequency of 0.5 for each
allele.
}
\examples{

#load example data
data(ASEset)
#access SnpAfList
alleleCountList <- alleleCounts(ASEset)
#get default map bias exp mean
matExpMean <- getDefaultMapBiasExpMean(alleleCountList)


}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{bias}
\keyword{mapping}
