% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxillary-methods.R
\docType{methods}
\name{getAlleleQuality}
\alias{getAlleleQuality}
\alias{getAlleleQuality,GAlignmentsList-method}
\title{snp quality data}
\usage{
getAlleleQuality(BamList, ...)

\S4method{getAlleleQuality}{GAlignmentsList}(
  BamList,
  GRvariants,
  fastq.format = "illumina.1.8",
  return.class = "array",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{BamList}{A \code{GAlignmentsList object} or \code{GRangesList object}
containing data imported from a bam file}

\item{...}{parameters to pass on}

\item{GRvariants}{A \code{GRanges object} that contains positions of SNPs to
retrieve.}

\item{fastq.format}{default 'illumina.1.8'}

\item{return.class}{'list' or 'array'}

\item{verbose}{Setting \code{verbose=TRUE} makes function more talkative}
}
\value{
\code{getAlleleQuality} returns a list of several data.frame objects,
each storing the count data for one SNP.
}
\description{
Given the positions of known SNPs, this function returns allele quality from
a BamGRL object
}
\details{
This function is used to retrieve the allele quality strings from specified positions
in a set of RNA-seq reads. The \code{BamList} argument will typically have
been created using the \code{impBamGAL} function on bam-files. The
\code{GRvariants} is either a GRanges with user-specified locations or else
it is generated through scanning the same bam-files as in \code{BamList} for
heterozygote locations (e.g. using \code{scanForHeterozygotes}). The
GRvariants will currently only accept locations having width=1,
corresponding to bi-allelic SNPs. The strand type information will be kept in the
returned object. If the strand is marked as unknown "*", it will be forced to the "+"
strand.

quaity information is extracted from the BamList object, and requires the presence of
mcols(BamList)[["qual"]] to contain quality sequences.
}
\examples{

#load example data
data(reads)
data(GRvariants)

#get counts at the three positions specified in GRvariants
alleleQualityArray <- getAlleleQuality(BamList=reads,GRvariants)

#place in ASEset object
alleleCountsArray <- getAlleleCounts(BamList=reads,GRvariants,
                     strand='*', return.class="array")

	a <- ASEsetFromArrays(GRvariants, countsUnknown = alleleCountsArray)
	aquals(a) <- alleleQualityArray
}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{allele}
\keyword{quality}
