% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxillary-functions-visuals.R
\name{barplot-lattice-support}
\alias{barplot-lattice-support}
\alias{barplotLatticeCounts}
\alias{barplotLatticeFraction}
\title{lattice barplot inner functions for ASEset objects}
\usage{
barplotLatticeFraction(identifier, ...)

barplotLatticeCounts(identifier, ...)
}
\arguments{
\item{identifier, }{the single snp name to plot}

\item{...}{used to pass on variables}
}
\description{
Generates lattice barplots for ASEset objects. Two levels of plotting detail
are provided: a detailed barplot of read counts by allele useful for fewer
samples and SNPs, and a less detailed barplot of the fraction of imbalance,
useful for more samples and SNPs.
}
\details{
\code{filter.pValue.fraction} is intended to remove p-value annotation with
very large difference in frequency, which could just be a sequencing
mistake. This is to avoid p-values like 1e-235 or similar.

\code{sampleColour}User specified colours, either given as named colours
('red', 'blue', etc) or as hexadecimal code. Can be either length 1 for all
samples, or else of a length corresponding to the number of samples for
individual colouring.
}
\examples{

a <- ASEset
name <- rownames(a)[1]

barplotLatticeFraction(identifier=name, x=a, astrand="+") 
barplotLatticeCounts(identifier=name,  x=a, astrand="+") 

}
\seealso{
\itemize{ \item The \code{\link{ASEset}} class which the barplot
function can be called up on.  }
}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{barplot}
