% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPSMs.R
\name{plotPSMs}
\alias{plotPSMs}
\title{plot PSMs from FT2 files and PSM results}
\usage{
plotPSMs(
  realScans,
  charges,
  Atom = "C13",
  Probs,
  BYcharge = c(1, 2),
  ftFileNames,
  scanNumbers,
  pepSeqs,
  proNames,
  path = "."
)
}
\arguments{
\item{realScans}{List of AAspectra objects of real scan}

\item{charges}{Integer vector of precursor charge of PSMs}

\item{Atom}{"C13" or "N15". Default is "C13"}

\item{Probs}{C13 or N15's abundance of PSMs}

\item{BYcharge}{Integer vector of B Y ion. Default is 1:2}

\item{ftFileNames}{Character vector of FT2 file names}

\item{scanNumbers}{Integer vector of scan number of PSMs}

\item{pepSeqs}{Character vector of peptide sequence of PSMs}

\item{proNames}{Character vector of protein name of PSMs}

\item{path}{Output path of pdf. Default is "."}
}
\value{
PDF files saved in the specified path
}
\description{
plot PSMs from FT2 files and PSM results
}
\examples{
element <- "C13"
demo_file <- system.file("extdata", "demo.psm.txt", package = "Aerith")
psm <- readPSMtsv(demo_file)
psm <- psm[psm$Filename == "Pan_052322_X13.FT2", ]
psm <- psm[psm$ScanNumber \%in\% c("4068", "2596", "8182"), ]
demo_file <- system.file("extdata", "X13_4068_2596_8182.FT2", package = "Aerith")
ft2 <- readAllScanMS2(demo_file)
ftFileNames <- psm$Filename
scanNumbers <- psm$ScanNumber
proNames <- psm$ProteinNames
charges <- psm$ParentCharge
pep <- psm$OriginalPeptide
pep <- stringr::str_sub(pep, 2, -2)
pct <- psm$SearchName
pct <- as.numeric(stringr::str_sub(
    stringr::str_split(pct, "_", simplify = TRUE)[, 2], 1, -4
)) / 100 / 1000
realScans <- getRealScans(ft2, scanNumbers)
tmp <- tempdir()
plotPSMs(
    realScans,
    charges,
    element,
    pct,
    BYcharge = 1:2,
    ftFileNames,
    scanNumbers,
    pep,
    proNames,
    path = tmp
)
list.files(tmp, pattern = ".pdf", full.names = TRUE)

}
