% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPSMs.R
\name{getRealScansWithCharges}
\alias{getRealScansWithCharges}
\title{get real scans with real charges and raw intensities from scans list of one ft file}
\usage{
getRealScansWithCharges(ft, scanNumbers)
}
\arguments{
\item{ft}{Scans list of one ft file}

\item{scanNumbers}{Integer vector of scan number of PSMs}
}
\value{
List of AAspectra objects of real scans
}
\description{
get real scans with real charges and raw intensities from scans list of one ft file
}
\examples{
scanNumbers <- c("2596", "8182")
demo_file <- system.file("extdata", "X13_4068_2596_8182.FT2", package = "Aerith")
ft2 <- readAllScanMS2(demo_file)
realScans <- getRealScansWithCharges(ft2, scanNumbers)
}
