% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_AUCell_plotHist.R
\name{AUCell_plotHist}
\alias{AUCell_plotHist}
\title{Plot AUC histogram}
\usage{
AUCell_plotHist(
  cellsAUC,
  aucThr = max(cellsAUC),
  nBreaks = 100,
  onColor = "dodgerblue4",
  offColor = "slategray2",
  ...
)
}
\arguments{
\item{cellsAUC}{Subset of the object returned by \code{\link{AUCell_calcAUC}}
(i.e. including only the gene-sets to plot)}

\item{aucThr}{AUC value planned to use as threshold
(to make sure the X axis includes it), if any.
Otherwise, the X axis extends to cover only the AUC values plotted.}

\item{nBreaks}{Number of 'bars' to plot (breaks argument for hist function).}

\item{onColor}{Color for the bars that pass the AUC threshold}

\item{offColor}{Color for the bars that do not pass the AUC threshold}

\item{...}{Other arguments to pass to \code{\link{hist}} function.}
}
\value{
List of histogram objects (invisible).
}
\description{
Plots the distribution of AUC across the cells
(for each gene-set) as an histogram.
}
\examples{
# This example is run using a fake expression matrix.
# Therefore, the output will be meaningless.

############# Fake expression matrix #############
set.seed(123)
exprMatrix <- matrix(data=sample(c(rep(0, 5000), sample(1:3, 5000, replace=TRUE))),
                     nrow=20, 
                     dimnames=list(paste("Gene", 1:20, sep=""), 
                                   paste("Cell", 1:500, sep="")))
dim(exprMatrix)
##################################################

############# Begining of the workflow ###########
# Step 1.
cells_rankings <- AUCell_buildRankings(exprMatrix, plotStats=FALSE)

# Step 2.
# (Gene set: 10 random genes)
genes <- sample(rownames(exprMatrix), 10)
geneSets <- list(geneSet1=genes)
# (aucMaxRank=5 to run with this fake example, it will return 'high' AUC values)
cells_AUC <- AUCell_calcAUC(geneSets, cells_rankings, aucMaxRank=5)
##################################################

# Plot histogram:
AUCell_plotHist(cells_AUC["geneSet1",], nBreaks=10)

}
\seealso{
See the package vignette for examples and more details:
\code{vignette("AUCell")}
}
