% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simulate_spectra}
\alias{simulate_spectra}
\title{Simulate a set of spectra}
\usage{
simulate_spectra(
  n.spectra,
  max.shift = 0.02,
  metab.percent = 0.5,
  metab.different = 4,
  add.noise = 0.07,
  mult.noise = 0.09
)
}
\arguments{
\item{n.spectra}{Number of spectra to simulate.}

\item{max.shift}{Maximum shift allowed for artificial deformation of pure
spectra (default to 0.02).}

\item{metab.percent}{Percentage of present metabolites in complex spectra
(default to 0.5).}

\item{metab.different}{Number of metabolites that are different between each 
complex spectra (default to 4).}

\item{add.noise, mult.noise}{additive and multiplicative noises. By default,
\code{add.noise = 0.15} and \code{mult.noise = 0.172}}
}
\value{
A list with a data frame of simulated spectra in columns and
a data frame of simulated quantifications.
}
\description{
Simulate a set of spectra based on the default library with shifts
}
\examples{
spectra <- simulate_spectra(n.spectra = 10)
}
