% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{importSpectraBruker}
\alias{importSpectraBruker}
\title{Import preprocessed metabolomic spectra from Bruker files}
\usage{
importSpectraBruker(
  name.dir,
  which.spectra = "first",
  ppm.grid = NULL,
  sample.names = NULL,
  ncores = 1,
  verbose = TRUE
)
}
\arguments{
\item{name.dir}{Path of the folder containing one subfolder by sample. Each
subfolder contains the Bruker files of this sample.}

\item{which.spectra}{If there is no folder with experiment number
(\code{all_spectra/<spectrum_name>/pdata/...}) set \code{which.spectra} to
\code{NULL}. Else if there is more than one spectrum by sample
(\code{all_spectra/<spectrum_name>/<experiment_number>/pdata/...}), which is
the spectrum to import (either always the first one with \code{which.spectra
= "first"}, always the last one with \code{which.spectra = "last"} or a
vector of length the number of spectra that specifies the number of each
spectrum to import).
Default to \code{"first"}.}

\item{ppm.grid}{Numeric vector of a unique grid (definition domain) for all
spectra (in ppm). Default to \code{NULL} (in which case, the default grid of
the pure library is used).}

\item{sample.names}{Character vector of sample names. Default to \code{NULL}
(in which case, folder names are used).}

\item{ncores}{Number of cores used in parallel evaluation. Default to
\code{1}.}

\item{verbose}{A boolean value to allow print out process information.}
}
\value{
A data frame with spectra in columns and chemical shifts (in ppm)
in rows.
}
\description{
Import preprocessed spectra from Bruker files contained in a single folder.
This folder contains one subfolder for each sample.
(optional) Spectra are baseline corrected, aligned and normalised by the area
under the curve during the importation.
}
\examples{
current_path <- system.file("extdata", "example_spectra", package = "ASICS")
spectra_data <- importSpectraBruker(current_path)
}
\seealso{
\code{\link{normaliseSpectra}}
\code{\link{alignSpectra}}
}
