% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AffinityNetworkFusion.R
\name{kNN_graph}
\alias{kNN_graph}
\title{Calculate k-nearest-neighbor graph from affinity matrix
and normalize it as transition matrix}
\usage{
kNN_graph(W, K)
}
\arguments{
\item{W}{affinity matrix (its elements are non-negative real numbers)}

\item{K}{the number of k nearest neighbors}
}
\value{
a transition matrix of the same shape as W
}
\description{
Calculate k-nearest-neighbor graph from affinity matrix
and normalize it as transition matrix
}
\examples{
D = matrix(runif(400),20)
W = affinity_matrix(D, 5)
S = kNN_graph(W, 5)
}
