% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expression_summaries.R
\name{pair_corr}
\alias{pair_corr}
\title{Pairwise scatter plot matrix and correlation plot of counts}
\usage{
pair_corr(df, log = TRUE, method = "pearson", use_subset = TRUE)
}
\arguments{
\item{df}{A data frame, containing the (raw/normalized/transformed) counts}

\item{log}{Logical, whether to convert the input values to log2 (with addition
of a pseudocount). Defaults to TRUE.}

\item{method}{Character string, one of \code{pearson} (default), \code{kendall}, or
\code{spearman} as in \code{cor}}

\item{use_subset}{Logical value. If TRUE, only 1000 values per sample will be used
to speed up the plotting operations.}
}
\value{
A plot with pairwise scatter plots and correlation coefficients
}
\description{
Pairwise scatter plot matrix and correlation plot of counts
}
\examples{

library("macrophage")
library("DESeq2")
data(gse, package = "macrophage")
## dds object
dds_macrophage <- DESeqDataSet(gse, design = ~ line + condition)
rownames(dds_macrophage) <- substr(rownames(dds_macrophage), 1, 15)
dds_macrophage <- estimateSizeFactors(dds_macrophage)

## Using just a subset for the example
pair_corr(counts(dds_macrophage, normalized = TRUE)[1:100, 1:8])
}
