% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_plot.R
\name{gene_plot}
\alias{gene_plot}
\title{Plot expression values for a gene}
\usage{
gene_plot(
  de_container,
  gene,
  intgroup = NULL,
  assay = "counts",
  annotation_obj = NULL,
  normalized = TRUE,
  transform = TRUE,
  labels_display = TRUE,
  labels_repel = TRUE,
  plot_type = "auto",
  return_data = FALSE
)
}
\arguments{
\item{de_container}{An object containing the data for a Differential
Expression workflow (e.g. \code{DESeq2}, \code{edgeR} or \code{limma}).
Currently, this can be a \code{DESeqDataSet} object, normally obtained after
running your data through the \code{DESeq2} framework.}

\item{gene}{Character, specifies the identifier of the feature (gene) to be
plotted}

\item{intgroup}{A character vector of names in \code{colData(de_container)} to use for
grouping. Note: the vector components should be categorical variables. Defaults
to NULL, which which would then select the first column of the \code{colData} slot.}

\item{assay}{Character, specifies with assay of the \code{de_container} object to use for
reading out the expression values. Defaults to "counts".}

\item{annotation_obj}{A \code{data.frame} object with the feature annotation
information, with at least two columns, \code{gene_id} and \code{gene_name}.}

\item{normalized}{Logical value, whether the expression values should be
normalized by their size factor. Defaults to TRUE, applies when \code{assay} is
"counts"}

\item{transform}{Logical value, corresponding whether to have log scale y-axis
or not. Defaults to TRUE.}

\item{labels_display}{Logical value. Whether to display the labels of samples,
defaults to TRUE.}

\item{labels_repel}{Logical value. Whether to use \code{ggrepel}'s functions to
place labels; defaults to TRUE}

\item{plot_type}{Character, one of "auto", "jitteronly", "boxplot", "violin",
or "sina". Defines the type of \code{geom_} to be used for plotting. Defaults to
\code{auto}, which in turn chooses one of the layers according to the number of
samples in the smallest group defined via \code{intgroup}}

\item{return_data}{Logical, whether the function should just return the
data.frame of expression values and covariates for custom plotting. Defaults
to FALSE.}
}
\value{
A \code{ggplot} object
}
\description{
Plot expression values (e.g. normalized counts) for a gene of interest, grouped
by experimental group(s) of interest
}
\details{
The result of this function can be fed directly to \code{\link[plotly:ggplotly]{plotly::ggplotly()}}
for interactive visualization, instead of the static \code{ggplot} viz.
}
\examples{
library("macrophage")
library("DESeq2")
library("org.Hs.eg.db")

# dds object
data(gse, package = "macrophage")
dds_macrophage <- DESeqDataSet(gse, design = ~ line + condition)
rownames(dds_macrophage) <- substr(rownames(dds_macrophage), 1, 15)
keep <- rowSums(counts(dds_macrophage) >= 10) >= 6
dds_macrophage <- dds_macrophage[keep, ]
# dds_macrophage <- DESeq(dds_macrophage)

# annotation object
anno_df <- data.frame(
  gene_id = rownames(dds_macrophage),
  gene_name = mapIds(org.Hs.eg.db,
    keys = rownames(dds_macrophage),
    column = "SYMBOL",
    keytype = "ENSEMBL"
  ),
  stringsAsFactors = FALSE,
  row.names = rownames(dds_macrophage)
)

gene_plot(
  de_container = dds_macrophage,
  gene = "ENSG00000125347",
  intgroup = "condition",
  annotation_obj = anno_df
)
}
