% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_mgmt.R
\name{de_table_painter}
\alias{de_table_painter}
\title{DE table painter}
\usage{
de_table_painter(
  res_de,
  rounding_digits = NULL,
  signif_digits = NULL,
  up_DE_color = "darkred",
  down_DE_color = "navyblue",
  logfc_column = "log2FoldChange",
  basemean_column = "baseMean",
  lfcse_column = "lfcSE",
  stat_column = "stat",
  pvalue_column = "pvalue",
  padj_column = "padj"
)
}
\arguments{
\item{res_de}{An object containing the results of the Differential Expression
analysis workflow (e.g. \code{DESeq2}, \code{edgeR} or \code{limma}). Currently,
this can be a \code{DESeqResults} object created using the \code{DESeq2} framework.
Or a data frame obtained from such an object through \code{\link[=deresult_to_df]{deresult_to_df()}}}

\item{rounding_digits}{Numeric value, specifying the number of digits to round
the numeric values of the DE table (except the p-values)}

\item{signif_digits}{Numeric value, specifying the number of significant digits
to display for the p-values in the DE table}

\item{up_DE_color}{Character string, specifying the color to use for coloring
the bar of upregulated genes.}

\item{down_DE_color}{Character string, specifying the color to use for coloring
the bar of downregulated genes.}

\item{logfc_column}{Character string, defining the name of the column in which
to find the log2 fold change.}

\item{basemean_column}{Character string, defining the name of the column in which
to find the average expression value.}

\item{lfcse_column}{Character string, defining the name of the column in which
to find the standard error of the log2 fold change.}

\item{stat_column}{Character string, defining the name of the column in which
to find the values of the test statistic.}

\item{pvalue_column}{Character string, defining the name of the column in which
to find the unadjusted p-values.}

\item{padj_column}{Character string, defining the name of the column in which
to find the adjusted p-values.}
}
\value{
A \code{datatable} object, ready to be rendered as a widget inside an
analysis Rmarkdown report.
}
\description{
Beautifying the aspect and looks of a DE results table
}
\details{
Feeding on the classical results of DE workflows, this function formats and
tries to prettify the representation of the key values in it.
}
\examples{
data(res_de_macrophage, package = "mosdef")
de_table_painter(res_macrophage_IFNg_vs_naive,
                 rounding_digits = 3,
                 signif_digits = 5)

## It is also possible to pass the "buttonified" table,
res_df_small <- deresult_to_df(res_macrophage_IFNg_vs_naive)[1:100, ]

buttonified_df <- buttonifier(res_df_small,
                              create_buttons_to = c("NCBI", "HPA"),
                              ens_col = "id",
                              ens_species = "Homo_sapiens",
                              output_format = "DF"
)

de_table_painter(buttonified_df,
                 rounding_digits = 3,
                 signif_digits = 5)
}
