% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{lapply_tryCatch}
\alias{lapply_tryCatch}
\title{lapply with tryCatch routine}
\usage{
lapply_tryCatch(X, FUN, err_res, ...)
}
\arguments{
\item{X}{a vector (atomic or list) or an \code{\link[base]{expression}}
    object.  Other objects (including classed objects) will be coerced
    by \code{base::\link[base]{as.list}}.}

\item{FUN}{the function to be applied to each element of \code{X}:
    see \sQuote{Details}.  In the case of functions like
    \code{+}, \code{\%*\%}, the function name must be backquoted or quoted.}

\item{err_res}{Function creating a result that should be output in case of 
error.}

\item{...}{optional arguments to \code{FUN}.}
}
\value{
List of elements as returned by \code{FUN}.
}
\description{
Used to run function iteratively over list, while using tryCatch to
catch warnings and errors to finally present a summary of issues rather
than error on each and every one. Used in \code{iterativeLRT} and
\code{iterativeModel}.
}
