% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{getOmnibusGroups}
\alias{getOmnibusGroups}
\title{Get omnibus groups from MiDAS object.}
\usage{
getOmnibusGroups(object, experiment)
}
\arguments{
\item{object}{\code{\link{MiDAS}} object.}

\item{experiment}{String specifying experiment.}
}
\value{
List of omnibus groups for a given experiment.
}
\description{
Get omnibus groups from MiDAS object.
}
\details{
For some experiments features can be naturally divided into groups
(here called omnibus groups). For example, in \code{"hla_aa"} experiment
features can be grouped by amino acid position (\code{"B_46_E"},
\code{"B_46_A"}) can be grouped into \code{B_46} group). Such groups can be
then used to perform omnibus test, see \code{\link{runMiDAS}} for more
details.
}
\examples{
getOmnibusGroups(object = MiDAS_tut_object,
                 experiment = "hla_aa")

}
