% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformFunction.R
\name{transformData}
\alias{transformData}
\alias{transformData,matrixOrHDF5-method}
\alias{transformData,ClusterExperiment-method}
\alias{transformData,SingleCellExperiment-method}
\alias{transformData,SummarizedExperiment-method}
\title{Transform the original data in a ClusterExperiment object}
\usage{
\S4method{transformData}{matrixOrHDF5}(object, transFun = NULL, isCount = FALSE)

\S4method{transformData}{ClusterExperiment}(object, whichAssay = 1, ...)

\S4method{transformData}{SingleCellExperiment}(object, whichAssay = 1, ...)

\S4method{transformData}{SummarizedExperiment}(object, ...)
}
\arguments{
\item{object}{a matrix, SummarizedExperiment, SingleCellExperiment or
ClusterExperiment object.}

\item{transFun}{a transformation function to be applied to the data. If the
transformation applied to the data creates an error or NA values, then the
function will throw an error. If object is of class
\code{ClusterExperiment}, the stored transformation will be used and giving
this parameter will result in an error.}

\item{isCount}{if \code{transFun=NULL}, then \code{isCount=TRUE} will
determine the transformation as defined by \code{function(x){log2(x+1)}},
and \code{isCount=FALSE} will give a transformation function
\code{function(x){x}}. Ignored if \code{transFun=NULL}. If object is of
class \code{ClusterExperiment}, the stored transformation will be used and
giving this parameter will result in an error.}

\item{whichAssay}{numeric or character specifying which assay to use. See
\code{\link[SummarizedExperiment]{assay}} for details.}

\item{...}{Values passed on the the 'matrix' method.}
}
\value{
A DataFrame defined by \code{assay(x)} suitably transformed
}
\description{
Provides the transformed data
}
\details{
The data matrix defined by \code{assay(x)} is transformed based on
  the transformation function either defined in x (in the case of a
\code{ClusterExperiment} object) or by user given values for other classes.
}
\examples{
mat <- matrix(data=rnorm(200), ncol=10)
mat[1,1] <- -1 #force a negative value
labels <- gl(5, 2)
cc <- ClusterExperiment(mat, as.numeric(labels), transformation =
function(x){x^2}) #define transformation as x^2
z<-transformData(cc)
}
