% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeBlankData.R, R/plottingHelpers.R
\docType{data}
\name{plottingFunctions}
\alias{plottingFunctions}
\alias{makeBlankData}
\alias{convertClusterLegend,ClusterExperiment-method}
\alias{convertClusterLegend}
\alias{showPalette}
\alias{bigPalette}
\alias{massivePalette}
\alias{setBreaks}
\alias{showHeatmapPalettes}
\alias{seqPal5}
\alias{seqPal2}
\alias{seqPal3}
\alias{seqPal4}
\alias{seqPal1}
\alias{plotClusterLegend,ClusterExperiment-method}
\alias{plotClusterLegend}
\title{Convert clusterLegend into useful formats}
\format{
An object of class \code{character} of length 56.

An object of class \code{character} of length 484.

An object of class \code{character} of length 16.

An object of class \code{character} of length 14.

An object of class \code{character} of length 11.

An object of class \code{character} of length 13.

An object of class \code{character} of length 11.
}
\usage{
makeBlankData(
  data,
  groupsOfFeatures = NULL,
  groupsOfSamples = NULL,
  nBlankFeatures = 1,
  nBlankSamples = 1
)

\S4method{convertClusterLegend}{ClusterExperiment}(
  object,
  output = c("plotAndLegend", "aheatmapFormat", "matrixNames", "matrixColors"),
  whichClusters = ifelse(output == "plotAndLegend", "primary", "all")
)

showPalette(colPalette = bigPalette, which = NULL, cex = 1)

bigPalette

massivePalette

setBreaks(data, breaks = NA, makeSymmetric = FALSE, returnBreaks = TRUE)

showHeatmapPalettes()

seqPal5

seqPal2

seqPal3

seqPal4

seqPal1

\S4method{plotClusterLegend}{ClusterExperiment}(
  object,
  whichCluster = "primary",
  clusterNames,
  title,
  add = FALSE,
  location = if (add) "topright" else "center",
  ...
)
}
\arguments{
\item{data}{matrix with samples on columns and features on rows.}

\item{groupsOfFeatures}{list, with each element of the list containing a
vector of numeric indices of features (rows).}

\item{groupsOfSamples}{list, with each element of the list containing a vector
of numeric indices of samples (columns).}

\item{nBlankFeatures}{the number of blank lines to add in the data matrix to
separate the groups of feature indices (will govern the amount of white
space if data is then fed to heatmap.)}

\item{nBlankSamples}{the number of blank lines to add in the data matrix to
separate the groups of sample indices (will govern the amount of white space
if data is then fed to heatmap.)}

\item{object}{a \code{ClusterExperiment} object.}

\item{output}{character value, indicating desired type of conversion.}

\item{whichClusters}{argument that can be either numeric or character vector
indicating the clusterings to be used. See details of \code{\link{getClusterIndex}}.}

\item{colPalette}{a vector of character colors. By default, the palette 
\code{bigPalette} is used}

\item{which}{numeric. Which colors to plot. Must be a numeric vector with
values between 1 and length of \code{colPalette}. If missing, all colors
plotted.}

\item{cex}{numeric value giving the cex for the text of the plot.}

\item{breaks}{either vector of breaks, or number of breaks (integer) or a
number between 0 and 1 indicating a quantile, between which evenly spaced
breaks should be calculated. If missing or NA, will determine evenly spaced
breaks in the range of the data.}

\item{makeSymmetric}{whether to make the range of the breaks symmetric around zero (only used if not all of the data is non-positive and not all of the data is non-negative)}

\item{returnBreaks}{logical as to whether to return the vector of breaks. See details.}

\item{whichCluster}{argument that can be a single numeric or character value
indicating the \emph{single} clustering to be used. Giving values that result in more than one clustering will result in an error. See details of \code{\link{getClusterIndex}}.}

\item{clusterNames}{vector of names for the clusters; vector should have names
that correspond to the clusterIds in the ClusterExperiment object. If this
argument is missing, will use the names in the "name" column of the clusterLegend
slot of the object.}

\item{title}{title for the clusterLegend plot}

\item{add}{logical. Whether legend should be added to the existing plot.}

\item{location}{character passed to \code{x} argument of legend indicating 
where to place legend.}

\item{...}{arguments passed to legend}
}
\value{
\code{makeBlankData} returns a list with items 
\itemize{
 \item{"dataWBlanks"}{ The data with the rows of NAs separating the given
 indices.} 
 \item{"rowNamesWBlanks"}{ A vector of characters giving the
 rownames for the data, including blanks for the NA rows. These are not given
 as rownames to the returned data because they are not necessarily unique.
 However, they can be given to the \code{labRow} argument of
 \code{\link[NMF]{aheatmap}} or \code{\link{plotHeatmap}}.}
 \item{"colNamesWBlanks"}{ A vector of characters giving the colnames for the
 data, including blanks for the NA rows. They can be given to the
 \code{labCol} argument of \code{\link[NMF]{aheatmap}} or
 \code{\link{plotHeatmap}}.} 
 \item{"featureGroupNamesWBlanks"}{ A vector of
 characters of the same length as the number of rows of the new data (i.e.
 with blanks) giving the group name for the data, indicating which group
 (i.e. which element of \code{groupsOfFeatures} list) the feature came from.
 If \code{groupsOfFeatures} has unique names, these names will be used, other
 wise "Feature Group1", "Feature Group2", etc. The NA rows are given NA
 values. } 
 \item{"sampleGroupNamesWBlanks"}{ A vector of characters of the
 same length as the number of columns of the new data (i.e. with blanks)
 giving the group name for the data, indicating which group (i.e. which
 element of \code{groupsOfFeatures} list) the feature came from. If
 \code{groupsOfFeatures} has unique names, these names will be used, other
 wise "SampleGroup1", "Group2", etc. The NA rows are given NA values. } }

If \code{output="plotAndLegend"}, \code{"convertClusterLegend"} will
  return a list that provides the necessary information to color samples
  according to cluster and create a legend for it:
 \itemize{
 \item{"colorVector"}{ A vector the same length as the number of samples,
 assigning a color to each cluster of the primaryCluster of the object.}
 \item{"legendNames"}{ A vector the length of the number of clusters of
 primaryCluster of the object giving the name of the cluster.}
 \item{"legendColors"}{ A vector the length of the number of clusters of
 primaryCluster of the object giving the color of the cluster.}
}

If \code{output="aheatmap"} a conversion of the clusterLegend to be
  in the format requested by \code{\link[NMF]{aheatmap}}. The column 'name'
  is used for the names and the column 'color' for the color of the clusters.

If \code{output="matrixNames"} or \code{"matrixColors"} a matrix the
  same dimension of \code{clusterMatrix(object)}, but with the cluster color
  or cluster name instead of the clusterIds, respectively.
}
\description{
Function for converting the information stored in the clusterLegend slot into
other useful formats.

Most of these functions are called internally by plotting
  functions, but are exported in case the user finds them useful.
}
\details{
\code{makeBlankData} pulls the data corresponding to the row indices
 in \code{groupsOfFeatures} adds lines of NA values into data between these
 groups. When given to heatmap, will create white space between these groups
 of features.

convertClusterLegend pulls out information stored in the
  \code{clusterLegend} slot of the object and returns it in useful format.

\code{bigPalette} is a long palette of colors (length 58) used by 
  \code{\link{plotClusters}} and accompanying functions. \code{showPalette}
  creates plot that gives index of each color in a vector of colors.
  \code{massivePalette} is a combination of \code{bigPalette} and the
  non-grey colors of \code{\link{colors}()} (length 487). 
  \code{massivePalette} is mainly useful for when doing
  \code{\link{plotClusters}} of a very large number of clusterings, each with
  many clusters, so that the code doesn't run out of colors. However, many of
  the colors will be very similar to each other.

\code{showPalette} will plot the \code{colPalette} colors with their
  labels and index.

if returnBreaks if FALSE, instead of returning the vector of breaks, the function will just return the second smallest and second largest value of the breaks. This is useful for alternatively just setting values of the data matrix larger than these values to this value if breaks was a percentile. This argument is only used if \code{breaks<1}, indicating truncating the breaks for large values of data.

\code{setBreaks} gives a set of breaks (of length 52) equally spaced
  between the boundaries of the data. If breaks is between 0 and 1, then the
  evenly spaced breaks are between these quantiles of the data.

\code{seqPal1}-\code{seqPal4} are palettes for the heatmap.
  \code{showHeatmapPalettes} will show you these palettes.
}
\examples{
data(simData)

x <- makeBlankData(simData[,1:10], groupsOfFeatures=list(c(5, 2, 3), c(20,
34, 25)))
plotHeatmap(x$dataWBlanks,clusterFeatures=FALSE)
showPalette()
showPalette(massivePalette,cex=0.6)
setBreaks(data=simData,breaks=.9)

#show the palette colors
showHeatmapPalettes()

#compare the palettes on heatmap
cl <- clusterSingle(simData, subsample=FALSE,
sequential=FALSE, 
mainClusterArgs=list(clusterFunction="pam", clusterArgs=list(k=8)))

\dontrun{
par(mfrow=c(2,3))
plotHeatmap(cl, colorScale=seqPal1, main="seqPal1")
plotHeatmap(cl, colorScale=seqPal2, main="seqPal2")
plotHeatmap(cl, colorScale=seqPal3, main="seqPal3")
plotHeatmap(cl, colorScale=seqPal4, main="seqPal4")
plotHeatmap(cl, colorScale=seqPal5, main="seqPal5")
par(mfrow=c(1,1))
}

}
\seealso{
\code{\link{plotHeatmap}}
}
\keyword{datasets}
