% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cBioPortal.R
\name{cBioPortal}
\alias{cBioPortal}
\alias{getStudies}
\alias{clinicalData}
\alias{molecularProfiles}
\alias{fetchData}
\alias{mutationData}
\alias{molecularData}
\alias{copyNumberData}
\alias{searchOps}
\alias{samplesInSampleLists}
\alias{sampleLists}
\alias{allSamples}
\alias{getSampleInfo}
\alias{genePanels}
\alias{getGenePanel}
\alias{genePanelMolecular}
\alias{getGenePanelMolecular}
\alias{geneTable}
\alias{queryGeneTable}
\alias{getDataByGenes}
\title{The R interface to the cBioPortal API Data Service}
\usage{
cBioPortal(
  hostname = "www.cbioportal.org",
  protocol = "https",
  api. = "/api/v2/api-docs",
  token = character()
)

getStudies(api, buildReport = FALSE)

clinicalData(api, studyId = NA_character_)

molecularProfiles(
  api,
  studyId = NA_character_,
  projection = c("SUMMARY", "ID", "DETAILED", "META")
)

fetchData(
  api,
  studyId,
  molecularProfileIds = NA_character_,
  entrezGeneIds = NULL,
  sampleIds = NULL
)

mutationData(
  api,
  molecularProfileIds = NA_character_,
  entrezGeneIds = NULL,
  sampleIds = NULL
)

molecularData(
  api,
  molecularProfileIds = NA_character_,
  entrezGeneIds = NULL,
  sampleIds = NULL
)

copyNumberData(
  api,
  molecularProfileIds = NA_character_,
  entrezGeneIds = NULL,
  sampleIds = NULL,
  sampleListId = NULL,
  discreteCopyNumberEventType = c("HOMDEL_AND_AMP", "HOMDEL", "AMP", "GAIN", "HETLOSS",
    "DIPLOID", "ALL"),
  projection = c("SUMMARY", "ID", "DETAILED", "META")
)

searchOps(api, keyword)

samplesInSampleLists(api, sampleListIds = NA_character_)

sampleLists(api, studyId = NA_character_)

allSamples(api, studyId = NA_character_)

getSampleInfo(
  api,
  studyId = NA_character_,
  sampleListIds = NULL,
  projection = c("SUMMARY", "ID", "DETAILED", "META")
)

genePanels(api)

getGenePanel(api, genePanelId = NA_character_)

genePanelMolecular(
  api,
  molecularProfileId = NA_character_,
  sampleListId = NULL,
  sampleIds = NULL
)

getGenePanelMolecular(api, molecularProfileIds = NA_character_, sampleIds)

geneTable(api, pageSize = 1000, pageNumber = 0, ...)

queryGeneTable(
  api,
  by = c("entrezGeneId", "hugoGeneSymbol"),
  genes = NA_character_,
  genePanelId = NA_character_
)

getDataByGenes(
  api,
  studyId = NA_character_,
  genes = NA_character_,
  genePanelId = NA_character_,
  by = c("entrezGeneId", "hugoGeneSymbol"),
  molecularProfileIds = NULL,
  sampleListId = NULL,
  sampleIds = NULL,
  ...
)
}
\arguments{
\item{hostname}{\code{character(1)} The internet location of the service (default:
'www.cbioportal.org')}

\item{protocol}{\code{character(1)} The internet protocol used to access the
hostname (default: 'https')}

\item{api.}{\code{character(1)} The directory location of the API protocol within
the hostname (default: '/api/v2/api-docs')}

\item{token}{\code{character(1)} The Authorization Bearer token e.g.,
"63eba81c-2591-4e15-9d1c-fb6e8e51e35d" or a path to text file.}

\item{api}{An API object of class \code{cBioPortal} from the \code{cBioPortal} function}

\item{buildReport}{\code{logical(1)} Indicates whether to append the build
information to the \code{getStudies()} table (default FALSE)}

\item{studyId}{\code{character(1)} Indicates the "studyId" as taken from
\code{getStudies}}

\item{projection}{\code{character(1)} (default: "SUMMARY") Specify the projection
type for data retrieval for details see API documentation}

\item{molecularProfileIds}{\code{character()} A vector of molecular profile IDs}

\item{entrezGeneIds}{\code{numeric()} A vector indicating entrez gene IDs}

\item{sampleIds}{\code{character()} Sample identifiers}

\item{sampleListId}{\code{character(1)} A sample list identifier as obtained from
\code{sampleLists()}}

\item{discreteCopyNumberEventType}{\code{character(1)} The copy number event type
to filter on. Must be one of "HOMDEL_AND_AMP" (default), "HOMDEL", "AMP",
"GAIN", "HETLOSS", "DIPLOID", or "ALL"}

\item{keyword}{\code{character(1)} Keyword or pattern for searching through
available operations}

\item{sampleListIds}{\code{character()} A vector of 'sampleListId' as obtained
from \code{sampleLists}}

\item{genePanelId}{\code{character(1)} Identifies the gene panel, as obtained from
the \code{genePanels} function}

\item{molecularProfileId}{\code{character(1)} Indicates a molecular profile ID}

\item{pageSize}{\code{numeric(1)} The number of rows in the table to return}

\item{pageNumber}{\code{numeric(1)} The pagination page number}

\item{...}{Additional arguments to lower level API functions}

\item{by}{\code{character(1)} Either 'entrezGeneId' or 'hugoGeneSymbol' for row
metadata (default: 'entrezGeneId')}

\item{genes}{\code{character()} Either Entrez gene identifiers or Hugo gene
symbols. When included, the 'by' argument indicates the type of identifier
provided and 'genePanelId' is ignored. Preference is given to Entrez IDs
due to faster query responses.}
}
\value{
\itemize{
\item cBioPortal: An API object of class 'cBioPortal'
\item cBioPortalData: A data object of class 'MultiAssayExperiment'
}
}
\description{
This section of the documentation lists the functions that allow
users to access the cBioPortal API. The main representation of the API can
be obtained from the \code{cBioPortal} function. The supporting functions listed
here give access to specific parts of the API and allow the user to explore
the API with individual calls. Many of the functions here are listed for
documentation purposes and are recommended for advanced usage only. Users
should only need to use the \code{cBioPortalData} main function to obtain data.
}
\section{API Metadata}{

\itemize{
\item getStudies: Obtain a table of studies and associated metadata and
optionally include a \code{buildReport} status (default FALSE) for each
study. When enabled, the 'api_build' and 'pack_build' columns will
be added to the table and will show if \code{MultiAssayExperiment} objects
can be generated for that particular study identifier (\code{studyId}). The
'api_build' column corresponds to datasets obtained with
\code{cBioPortalData} and the 'pack_build' column corresponds to datsets
loaded via \code{cBioDataPack}. Note that \code{resourceCounts} is removed from
the returned table for simplicity. To get the resource counts manually,
use \code{api$getStudyUsingGET()}.
}


\itemize{
\item searchOps - Search through API operations with a keyword
}


\itemize{
\item sampleLists - obtain all \code{sampleListIds} for a particular \code{studyId}
}


\itemize{
\item allSamples - obtain all samples within a particular \code{studyId}
}


\itemize{
\item genePanels - Show all available gene panels
}


\itemize{
\item geneTable - Get a table of all genes by 'entrezGeneId' and
'hugoGeneSymbol'
}


\itemize{
\item queryGeneTable - Get a table for only the \code{genes} or \code{genePanelId} of
interest. Gene inputs are identified with the \code{by} argument
}
}

\section{Patient Data}{

\itemize{
\item clinicalData - Obtain clinical data for a particular study identifier
('studyId')
}
}

\section{Molecular Profiles}{

\itemize{
\item molecularProfiles - Produce a molecular profiles dataset for a given
study identifier ('studyId')
}
}

\section{Molecular Data}{

\itemize{
\item fetchData - A convenience function to download both mutation and
molecular data with \code{molecularProfileId}, \code{entrezGeneIds}, and
\code{sampleIds}
}


\itemize{
\item mutationData - Produce a dataset of mutation data using
\code{molecularProfileId}, \code{entrezGeneIds}, and \code{sampleIds}
}


\itemize{
\item molecularData - Produce a dataset of molecular profile data based on
\code{molecularProfileId}, \code{entrezGeneIds}, and \code{sampleIds}
}
}

\section{Copy Number Data}{

\itemize{
\item copyNumberData - Produce a dataset of copy number data based on
\code{molecularProfileId}, \code{sampleListId}, \code{discreteCopyNumberEventType}, and
\code{projection}
}
}

\section{Sample Data}{

\itemize{
\item samplesInSampleLists - get all samples associated with a 'sampleListId'
}


\itemize{
\item getSampleInfo - Obtain sample metadata for a particular \code{studyId} or
\code{sampleListId}
}
}

\section{Gene Panels}{

\itemize{
\item getGenePanels - Obtain the gene panel for a particular 'genePanelId'
}


\itemize{
\item genePanelMolecular - get gene panel data for a particular
\code{molecularProfileId} and either a vector of \code{sampleListId} or \code{sampleId}
}


\itemize{
\item getGenePanelMolecular - get gene panel data for multiple
\code{molecularProfileId}s and a vector of \code{sampleIds}
}
}

\section{Genes}{

\itemize{
\item getDataByGenes - Download data for a number of genes within
\code{molecularProfileId} indicators, optionally a \code{sampleListId} can be
provided.
}
}

\examples{
cbio <- cBioPortal()

getStudies(api = cbio)

clinicalData(cbio, "acc_tcga")

molecularProfiles(cbio, "acc_tcga")

fetchData(
    api = cbio, studyId = "acc_tcga",
    molecularProfileIds = c(
        "acc_tcga_mutations", "acc_tcga_gistic", "acc_tcga_rppa"
    ),
    entrezGeneIds = 1:1000,
    sampleIds = c("TCGA-OR-A5J1-01", "TCGA-OR-A5J2-01")
)
mutationData(
    api = cbio,
    molecularProfileIds = "acc_tcga_mutations",
    entrezGeneIds = 1:1000,
    sampleIds = c("TCGA-OR-A5J1-01", "TCGA-OR-A5J2-01")
)

molecularData(
    api = cbio,
    molecularProfileIds = c("acc_tcga_rna_seq_v2_mrna", "acc_tcga_rppa"),
    entrezGeneIds = 1:100,
    sampleIds = c("TCGA-OR-A5J1-01", "TCGA-OR-A5J2-01")
)

## obtain molecularProfileId for discrete copy number alteration data
molecularProfiles(cbio, "acc_tcga") |>
    dplyr::filter(
        molecularAlterationType == "COPY_NUMBER_ALTERATION" &
        datatype == "DISCRETE"
    )

copyNumberData(
    api = cbio,
    molecularProfileIds = "acc_tcga_gistic",
    entrezGeneIds = 25,
    sampleListId = "acc_tcga_all"
)

searchOps(api = cbio, keyword = "molecular")

samplesInSampleLists(
    api = cbio,
    sampleListIds = c("acc_tcga_rppa", "acc_tcga_cnaseq")
)

sampleLists(api = cbio, studyId = "acc_tcga")

genePanels(cbio)

getGenePanel(cbio, "AmpliSeq")

queryGeneTable(api = cbio, by = "entrezGeneId", genes = 7157)

getDataByGenes(
    api = cbio,
    studyId = "acc_tcga",
    genes = 1,
    by = "entrezGeneId",
    molecularProfileIds = "acc_tcga_rna_seq_v2_mrna",
    sampleListId = "acc_tcga_rna_seq_v2_mrna"
)

}
