% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_assertions.R
\name{is_scalar_subset}
\alias{is_scalar_subset}
\alias{assert_scalar_subset}
\title{Is scalar subset}
\usage{
is_scalar_subset(
  x,
  y,
  .xname = get_name_in_parent(x),
  .yname = get_name_in_parent(y)
)

assert_scalar_subset(
  x,
  y,
  .xname = get_name_in_parent(x),
  .yname = get_name_in_parent(y)
)
}
\arguments{
\item{x}{scalar}

\item{y}{SummarizedExperiment}

\item{.xname}{name of x}

\item{.yname}{name of y}
}
\description{
Is scalar subset
}
\examples{
file <- system.file('extdata/fukuda20.proteingroups.txt', package = 'autonomics')
object <- read_maxquant_proteingroups(file)
is_scalar_subset('subgroup',     svars(object))
is_scalar_subset('subject',      svars(object))
assert_scalar_subset('subgroup', svars(object))
}
