% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_zscore.R
\name{check_zscore}
\alias{check_zscore}
\title{Check for Z-score column}
\usage{
check_zscore(
  sumstats_dt,
  imputation_ind,
  compute_z = "BETA",
  force_new_z = FALSE,
  standardise_headers = FALSE,
  mapping_file
)
}
\arguments{
\item{sumstats_dt}{data table obj of the summary statistics file for the
GWAS.}

\item{imputation_ind}{Binary Should a column be added for each imputation
step to show what SNPs have imputed values for differing fields. This
includes a field denoting SNP allele flipping (flipped). \strong{Note}
these columns will be in the formatted summary statistics returned. Default
is FALSE.}

\item{compute_z}{Whether to compute Z-score column. Default is FALSE. This
can be computed from Beta and SE with (Beta/SE) or P
(Z:=sign(BETA)*sqrt(stats::qchisq(P,1,lower=FALSE))).
\strong{Note} that imputing the Z-score from P for every SNP will not be
perfectly correct and may result in a loss of power. This should only be done
as a last resort. Use 'BETA' to impute by BETA/SE and 'P' to impute by SNP
p-value.}

\item{force_new_z}{When a "Z" column already exists, it will be used by
default. To override and compute a new Z-score column from P set
\code{force_new_z=TRUE}.}

\item{standardise_headers}{Run
\code{standardise_sumstats_column_headers_crossplatform} first.}

\item{mapping_file}{MungeSumstats has a pre-defined column-name mapping file
which should cover the most common column headers and their interpretations.
However, if a column header that is in your file is missing of the mapping we
give is incorrect you can supply your own mapping file. Must be a 2 column
dataframe with column names "Uncorrected" and "Corrected". See
data(sumstatsColHeaders) for default mapping and necessary format.}
}
\value{
\code{list("sumstats_dt"=sumstats_dt)}
}
\description{
The following ensures that a Z-score column is present.
The Z-score formula we used here is a R implementation of the formula
used in \href{https://github.com/bulik/ldsc/blob/aa33296abac9569a6422ee6ba7eb4b902422cc74/munge_sumstats.py#L363}{LDSC's munge_sumstats.py}:
}
\details{
\code{np.sqrt(chi2.isf(P, 1))}

The R implementation is adapted from the \code{GenomicSEM::munge} function,
after optimizing for speed using \code{data.table}:

\code{sumstats_dt[,Z:=sign(BETA)*sqrt(stats::qchisq(P,1,lower=FALSE))]}

\emph{NOTE}: \code{compute_z} is set to \code{TRUE} by
default to ensure standardisation
of the "Z" column (which can be computed differently in different datasets).
}
\keyword{internal}
