% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MethylMix.R
\name{MethylMix_MixtureModel}
\alias{MethylMix_MixtureModel}
\title{The MethylMix_MixtureModel function}
\usage{
MethylMix_MixtureModel(
  METcancer,
  METnormal = NULL,
  FunctionalGenes,
  NoNormalMode = FALSE
)
}
\arguments{
\item{METcancer}{matrix with methylation data for cancer samples (genes in rows, samples in columns).}

\item{METnormal}{matrix with methylation data for normal samples (genes in rows, samples in columns). If NULL no comparison to normal samples will be done.}

\item{FunctionalGenes}{vector with genes names to be considered for the mixture models.}

\item{NoNormalMode}{logical, if TRUE no comparison to normal samples is performed. Defaults to FALSE.}
}
\value{
MethylationStates matrix of DM values, with driver genes in the rows and samples in the columns.

NrComponents matrix with the number of components identified for each driver gene.

Models list with the mixture model fitted for each driver gene.

MethylationDrivers character vector with the genes found by MethylMix as differentially methylated and transcriptionally predictive (driver genes).

MixtureStates a list with a matrix for each driver gene containing the DM values.

Classifications a vector indicating to which component each sample was assigned.
}
\description{
Internal. Prepares all the structures to store the results and calls in a foreach loop a function that fits the mixture model in each gene.
}
\keyword{internal}
